/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.device;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecordingConfiguration;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingHistoryEventName;
import com.amazonaws.services.chime.sdk.meetings.device.DefaultDeviceController;
import com.amazonaws.services.chime.sdk.meetings.device.DeviceChangeObserver;
import com.amazonaws.services.chime.sdk.meetings.device.DeviceController;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDevice;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDeviceType;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientState;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.DefaultAudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0017J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\rH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0016J\b\u0010$\u001a\u00020\u0018H\u0007J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010!\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0018H\u0016R\u000e\u0010\u000f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/device/DefaultDeviceController;", "Lcom/amazonaws/services/chime/sdk/meetings/device/DeviceController;", "context", "Landroid/content/Context;", "audioClientController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientController;", "videoClientController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;", "eventAnalyticsController", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "audioManager", "Landroid/media/AudioManager;", "buildVersion", "", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientController;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;Landroid/media/AudioManager;I)V", "AUDIO_MANAGER_API_LEVEL", "audioDeviceCallback", "Landroid/media/AudioDeviceCallback;", "deviceChangeObservers", "", "Lcom/amazonaws/services/chime/sdk/meetings/device/DeviceChangeObserver;", "receiver", "Landroid/content/BroadcastReceiver;", "addDeviceChangeObserver", "", "observer", "chooseAudioDevice", "mediaDevice", "Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "getActiveAudioDevice", "getActiveCamera", "getReadableType", "", "type", "listAudioDevices", "", "notifyAudioDeviceChange", "removeDeviceChangeObserver", "setupAudioDevice", "Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDeviceType;", "switchCamera", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultDeviceController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDeviceController.kt\ncom/amazonaws/services/chime/sdk/meetings/device/DefaultDeviceController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n766#2:278\n857#2,2:279\n288#2,2:281\n288#2,2:283\n288#2,2:285\n*S KotlinDebug\n*F\n+ 1 DefaultDeviceController.kt\ncom/amazonaws/services/chime/sdk/meetings/device/DefaultDeviceController\n*L\n124#1:278\n124#1:279,2\n184#1:281,2\n196#1:283,2\n202#1:285,2\n*E\n"})
public final class DefaultDeviceController
implements DeviceController {
    @NotNull
    private final Context context;
    @NotNull
    private final AudioClientController audioClientController;
    @NotNull
    private final VideoClientController videoClientController;
    @NotNull
    private final EventAnalyticsController eventAnalyticsController;
    @NotNull
    private final AudioManager audioManager;
    private final int buildVersion;
    @NotNull
    private final Set<DeviceChangeObserver> deviceChangeObservers;
    private final int AUDIO_MANAGER_API_LEVEL;
    @Nullable
    private BroadcastReceiver receiver;
    @Nullable
    private AudioDeviceCallback audioDeviceCallback;

    public DefaultDeviceController(@NotNull Context context, @NotNull AudioClientController audioClientController, @NotNull VideoClientController videoClientController, @NotNull EventAnalyticsController eventAnalyticsController, @NotNull AudioManager audioManager, int buildVersion) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)audioClientController, (String)"audioClientController");
        Intrinsics.checkNotNullParameter((Object)videoClientController, (String)"videoClientController");
        Intrinsics.checkNotNullParameter((Object)eventAnalyticsController, (String)"eventAnalyticsController");
        Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
        this.context = context;
        this.audioClientController = audioClientController;
        this.videoClientController = videoClientController;
        this.eventAnalyticsController = eventAnalyticsController;
        this.audioManager = audioManager;
        this.buildVersion = buildVersion;
        this.deviceChangeObservers = ConcurrentSet.Companion.createConcurrentSet();
        this.AUDIO_MANAGER_API_LEVEL = 23;
        if (this.buildVersion >= this.AUDIO_MANAGER_API_LEVEL) {
            this.audioDeviceCallback = new AudioDeviceCallback(){

                public void onAudioDevicesAdded(@Nullable AudioDeviceInfo[] addedDevices) {
                    this.notifyAudioDeviceChange();
                }

                public void onAudioDevicesRemoved(@Nullable AudioDeviceInfo[] removedDevices) {
                    this.notifyAudioDeviceChange();
                }
            };
            this.audioManager.registerAudioDeviceCallback(this.audioDeviceCallback, null);
        } else {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                    Intent intent2 = intent;
                    if (Intrinsics.areEqual((Object)(intent2 != null ? intent2.getAction() : null), (Object)"android.bluetooth.device.action.ACL_CONNECTED")) {
                        Thread.sleep(1000L);
                    }
                    this.notifyAudioDeviceChange();
                }
            };
            this.context.registerReceiver(this.receiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
            this.context.registerReceiver(this.receiver, new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED"));
            this.context.registerReceiver(this.receiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
        }
    }

    public /* synthetic */ DefaultDeviceController(Context context, AudioClientController audioClientController, VideoClientController videoClientController, EventAnalyticsController eventAnalyticsController, AudioManager audioManager, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            Object object = context.getSystemService("audio");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
            audioManager = (AudioManager)object;
        }
        if ((n2 & 0x20) != 0) {
            n = Build.VERSION.SDK_INT;
        }
        this(context, audioClientController, videoClientController, eventAnalyticsController, audioManager, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MediaDevice> listAudioDevices() {
        if (this.buildVersion >= this.AUDIO_MANAGER_API_LEVEL) {
            List list;
            boolean isWiredHeadsetOn = false;
            boolean isHandsetAvailable = false;
            Object[] objectArray = new Integer[]{1, 18};
            Set handsetDevicesInfo = SetsKt.setOf((Object[])objectArray);
            List audioDevices = new ArrayList();
            int wiredDeviceCount = 0;
            AudioDeviceInfo[] audioDeviceInfoArray = this.audioManager.getDevices(2);
            Intrinsics.checkNotNullExpressionValue((Object)audioDeviceInfoArray, (String)"getDevices(...)");
            for (AudioDeviceInfo device : audioDeviceInfoArray) {
                if (device.getType() == 3 || device.getType() == 4 || device.getType() == 22) {
                    isWiredHeadsetOn = true;
                    ++wiredDeviceCount;
                }
                if (handsetDevicesInfo.contains(device.getType())) {
                    if (isHandsetAvailable) continue;
                    isHandsetAvailable = true;
                }
                if (device.getType() == 8) continue;
                audioDevices.add(new MediaDevice(device.getProductName() + " (" + this.getReadableType(device.getType()) + ')', MediaDeviceType.Companion.fromAudioDeviceInfo(device.getType()), null, 4, null));
            }
            if (wiredDeviceCount > 1) {
                audioDevices.removeIf(arg_0 -> DefaultDeviceController.listAudioDevices$lambda$0(listAudioDevices.1.INSTANCE, arg_0));
            }
            if (isWiredHeadsetOn) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = audioDevices;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    MediaDevice it = (MediaDevice)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getType() != MediaDeviceType.AUDIO_HANDSET)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = audioDevices;
            }
            return list;
        }
        List res = new ArrayList();
        res.add(new MediaDevice(this.getReadableType(2), MediaDeviceType.AUDIO_BUILTIN_SPEAKER, null, 4, null));
        if (this.audioManager.isWiredHeadsetOn()) {
            res.add(new MediaDevice(this.getReadableType(3), MediaDeviceType.AUDIO_WIRED_HEADSET, null, 4, null));
        } else {
            res.add(new MediaDevice(this.getReadableType(1), MediaDeviceType.AUDIO_HANDSET, null, 4, null));
        }
        if (this.audioManager.isBluetoothScoOn()) {
            res.add(new MediaDevice(this.getReadableType(7), MediaDeviceType.AUDIO_BLUETOOTH, null, 4, null));
        }
        return res;
    }

    @Override
    public void chooseAudioDevice(@NotNull MediaDevice mediaDevice) {
        int n;
        Intrinsics.checkNotNullParameter((Object)mediaDevice, (String)"mediaDevice");
        if (DefaultAudioClientController.Companion.getAudioClientState() != AudioClientState.STARTED) {
            return;
        }
        this.setupAudioDevice(mediaDevice.getType());
        switch (WhenMappings.$EnumSwitchMapping$0[mediaDevice.getType().ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        int route = n;
        boolean selected = this.audioClientController.setRoute(route);
        if (selected) {
            this.eventAnalyticsController.pushHistory(MeetingHistoryEventName.audioInputSelected);
        }
    }

    @Override
    @RequiresApi(value=24)
    @Nullable
    public MediaDevice getActiveAudioDevice() {
        if (this.buildVersion >= 24) {
            List list = this.audioManager.getActiveRecordingConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getActiveRecordingConfigurations(...)");
            if (!((Collection)list).isEmpty()) {
                AudioDeviceInfo device;
                Object v2;
                block8: {
                    List list2 = this.audioManager.getActiveRecordingConfigurations();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getActiveRecordingConfigurations(...)");
                    Iterable $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        AudioRecordingConfiguration config = (AudioRecordingConfiguration)element$iv;
                        boolean bl = false;
                        if (!(config.getAudioDevice() != null)) continue;
                        v2 = element$iv;
                        break block8;
                    }
                    v2 = null;
                }
                AudioRecordingConfiguration audioRecordingConfiguration = v2;
                Object object = device = audioRecordingConfiguration != null ? audioRecordingConfiguration.getAudioDevice() : null;
                if (device != null) {
                    Object v5;
                    block9: {
                        int type = device.getType();
                        MediaDeviceType mediaDeviceType = null;
                        mediaDeviceType = MediaDeviceType.Companion.fromAudioDeviceInfo(type);
                        if (type == 15) {
                            mediaDeviceType = this.audioManager.isSpeakerphoneOn() ? MediaDeviceType.Companion.fromAudioDeviceInfo(2) : MediaDeviceType.Companion.fromAudioDeviceInfo(1);
                        }
                        Iterable $this$firstOrNull$iv = this.listAudioDevices();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            MediaDevice it = (MediaDevice)element$iv;
                            boolean bl = false;
                            if (!(it.getType() == mediaDeviceType)) continue;
                            v5 = element$iv;
                            break block9;
                        }
                        v5 = null;
                    }
                    return v5;
                }
                if (this.audioManager.isSpeakerphoneOn()) {
                    Object v6;
                    block10: {
                        Iterable $this$firstOrNull$iv = this.listAudioDevices();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            MediaDevice it = (MediaDevice)element$iv;
                            boolean bl = false;
                            if (!(it.getType() == MediaDeviceType.AUDIO_BUILTIN_SPEAKER)) continue;
                            v6 = element$iv;
                            break block10;
                        }
                        v6 = null;
                    }
                    return v6;
                }
            }
        }
        return null;
    }

    private final void setupAudioDevice(MediaDeviceType type) {
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                AudioManager audioManager;
                AudioManager $this$setupAudioDevice_u24lambda_u245 = audioManager = this.audioManager;
                boolean bl = false;
                $this$setupAudioDevice_u24lambda_u245.stopBluetoothSco();
                $this$setupAudioDevice_u24lambda_u245.setMode(3);
                $this$setupAudioDevice_u24lambda_u245.setBluetoothScoOn(false);
                $this$setupAudioDevice_u24lambda_u245.setSpeakerphoneOn(true);
                break;
            }
            case 2: {
                AudioManager audioManager;
                AudioManager $this$setupAudioDevice_u24lambda_u246 = audioManager = this.audioManager;
                boolean bl = false;
                $this$setupAudioDevice_u24lambda_u246.setMode(3);
                $this$setupAudioDevice_u24lambda_u246.setSpeakerphoneOn(false);
                $this$setupAudioDevice_u24lambda_u246.startBluetoothSco();
                $this$setupAudioDevice_u24lambda_u246.setBluetoothScoOn(true);
                break;
            }
            default: {
                AudioManager audioManager;
                AudioManager $this$setupAudioDevice_u24lambda_u247 = audioManager = this.audioManager;
                boolean bl = false;
                $this$setupAudioDevice_u24lambda_u247.stopBluetoothSco();
                $this$setupAudioDevice_u24lambda_u247.setBluetoothScoOn(false);
                $this$setupAudioDevice_u24lambda_u247.setMode(3);
                $this$setupAudioDevice_u24lambda_u247.setSpeakerphoneOn(false);
            }
        }
    }

    private final String getReadableType(int type) {
        String string;
        switch (type) {
            case 3: {
                string = "Wired Headset";
                break;
            }
            case 2: {
                string = "Speaker";
                break;
            }
            case 4: {
                string = "Wired Headphone";
                break;
            }
            case 22: {
                string = "USB Headset";
                break;
            }
            case 1: 
            case 18: {
                string = "Handset";
                break;
            }
            case 7: 
            case 8: {
                string = "Bluetooth";
                break;
            }
            default: {
                string = "Unknown (AudioDeviceInfo: " + type + ')';
            }
        }
        return string;
    }

    @Override
    @Nullable
    public MediaDevice getActiveCamera() {
        return this.videoClientController.getActiveCamera();
    }

    @Override
    public void switchCamera() {
        this.videoClientController.switchCamera();
    }

    @Override
    public void addDeviceChangeObserver(@NotNull DeviceChangeObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.deviceChangeObservers.add(observer);
    }

    @Override
    public void removeDeviceChangeObserver(@NotNull DeviceChangeObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.deviceChangeObservers.remove(observer);
    }

    @VisibleForTesting(otherwise=2)
    public final void notifyAudioDeviceChange() {
        ObserverUtils.Companion.notifyObserverOnMainThread(this.deviceChangeObservers, (Function1)new Function1<DeviceChangeObserver, Unit>(this){
            final /* synthetic */ DefaultDeviceController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DeviceChangeObserver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onAudioDeviceChanged(this.this$0.listAudioDevices());
            }
        });
    }

    private static final boolean listAudioDevices$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaDeviceType.values().length];
            try {
                nArray[MediaDeviceType.AUDIO_BUILTIN_SPEAKER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaDeviceType.AUDIO_BLUETOOTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaDeviceType.AUDIO_WIRED_HEADSET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaDeviceType.AUDIO_USB_HEADSET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

