/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoContentHint;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoResolution;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSink;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.CaptureSourceObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.SurfaceTextureCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCore;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlUtil;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.video.TimestampAligner;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.android.HandlerDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u0002032\u0006\u00107\u001a\u00020#H\u0016J\b\u00108\u001a\u000203H\u0002J\b\u00109\u001a\u000203H\u0002J\b\u0010:\u001a\u000203H\u0016J\u0010\u0010;\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0010\u0010<\u001a\u0002032\u0006\u00107\u001a\u00020#H\u0016J\u0010\u0010=\u001a\u0002032\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u000203H\u0016J\b\u0010A\u001a\u000203H\u0016J\b\u0010B\u001a\u000203H\u0002R\u000e\u0010\f\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020%X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultSurfaceTextureCaptureSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSource;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "width", "", "height", "contentHint", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;IILcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;)V", "DUMMY_PBUFFER_OFFSET", "RESEND_DELAY_BUFFER_MS", "TAG", "", "getContentHint", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "eglCore", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCore;", "handler", "Landroid/os/Handler;", "lastAlignedTimestamp", "", "Ljava/lang/Long;", "minFps", "getMinFps", "()I", "setMinFps", "(I)V", "pendingAvailableFrame", "", "releasePending", "sinks", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSink;", "surface", "Landroid/view/Surface;", "getSurface", "()Landroid/view/Surface;", "setSurface", "(Landroid/view/Surface;)V", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "textureBufferInFlight", "textureId", "thread", "Landroid/os/HandlerThread;", "timestampAligner", "Lcom/xodee/client/video/TimestampAligner;", "addCaptureSourceObserver", "", "observer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/CaptureSourceObserver;", "addVideoSink", "sink", "completeRelease", "onFrameReleased", "release", "removeCaptureSourceObserver", "removeVideoSink", "setMaxResolution", "maxResolution", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoResolution;", "start", "stop", "tryCapturingFrame", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultSurfaceTextureCaptureSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSurfaceTextureCaptureSource.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultSurfaceTextureCaptureSource\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,244:1\n32#2,2:245\n*S KotlinDebug\n*F\n+ 1 DefaultSurfaceTextureCaptureSource.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultSurfaceTextureCaptureSource\n*L\n200#1:245,2\n*E\n"})
public final class DefaultSurfaceTextureCaptureSource
implements SurfaceTextureCaptureSource {
    @NotNull
    private final Logger logger;
    private final int width;
    private final int height;
    @NotNull
    private final VideoContentHint contentHint;
    @NotNull
    private final EglCoreFactory eglCoreFactory;
    public Surface surface;
    private int textureId;
    private SurfaceTexture surfaceTexture;
    private EglCore eglCore;
    @NotNull
    private final HandlerThread thread;
    @NotNull
    private final Handler handler;
    @NotNull
    private final TimestampAligner timestampAligner;
    private boolean pendingAvailableFrame;
    private boolean textureBufferInFlight;
    private boolean releasePending;
    private int minFps;
    private final int RESEND_DELAY_BUFFER_MS;
    @Nullable
    private Long lastAlignedTimestamp;
    @NotNull
    private Set<VideoSink> sinks;
    @NotNull
    private final String TAG;
    private final int DUMMY_PBUFFER_OFFSET;

    public DefaultSurfaceTextureCaptureSource(@NotNull Logger logger, int width, int height, @NotNull VideoContentHint contentHint, @NotNull EglCoreFactory eglCoreFactory) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)contentHint), (String)"contentHint");
        Intrinsics.checkNotNullParameter((Object)eglCoreFactory, (String)"eglCoreFactory");
        this.logger = logger;
        this.width = width;
        this.height = height;
        this.contentHint = contentHint;
        this.eglCoreFactory = eglCoreFactory;
        this.thread = new HandlerThread("DefaultSurfaceTextureCaptureSource");
        this.timestampAligner = new TimestampAligner();
        this.RESEND_DELAY_BUFFER_MS = 10;
        this.sinks = ConcurrentSet.Companion.createConcurrentSet();
        this.TAG = "SurfaceTextureCaptureSource";
        this.thread.start();
        this.handler = new Handler(this.thread.getLooper());
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultSurfaceTextureCaptureSource this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var2_3;
                        EglCore eglCore;
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.eglCore = this.this$0.eglCoreFactory.createEglCore();
                        int[] nArray = new int[]{12375, this.this$0.width, 12374, this.this$0.height, 12344};
                        int[] surfaceAttributes = nArray;
                        EglCore eglCore2 = this.this$0.eglCore;
                        if (eglCore2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
                            eglCore2 = null;
                        }
                        if ((eglCore = this.this$0.eglCore) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
                            eglCore = null;
                        }
                        EGLDisplay eGLDisplay = eglCore.getEglDisplay();
                        EglCore eglCore3 = this.this$0.eglCore;
                        if (eglCore3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
                            eglCore3 = null;
                        }
                        EGLSurface eGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)eGLDisplay, (EGLConfig)eglCore3.getEglConfig(), (int[])var2_3, (int)this.this$0.DUMMY_PBUFFER_OFFSET);
                        Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"eglCreatePbufferSurface(...)");
                        eglCore2.setEglSurface(eGLSurface);
                        EglCore eglCore4 = this.this$0.eglCore;
                        if (eglCore4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
                            eglCore4 = null;
                        }
                        EGLDisplay eGLDisplay2 = eglCore4.getEglDisplay();
                        EglCore eglCore5 = this.this$0.eglCore;
                        if (eglCore5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
                            eglCore5 = null;
                        }
                        EGLSurface eGLSurface2 = eglCore5.getEglSurface();
                        EglCore eglCore6 = this.this$0.eglCore;
                        if (eglCore6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
                            eglCore6 = null;
                        }
                        EGLSurface eGLSurface3 = eglCore6.getEglSurface();
                        EglCore eglCore7 = this.this$0.eglCore;
                        if (eglCore7 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
                            eglCore7 = null;
                        }
                        EGL14.eglMakeCurrent((EGLDisplay)eGLDisplay2, (EGLSurface)eGLSurface2, (EGLSurface)eGLSurface3, (EGLContext)eglCore7.getEglContext());
                        GlUtil.INSTANCE.checkGlError("Failed to set dummy surface to initialize surface texture video source");
                        this.this$0.textureId = GlUtil.INSTANCE.generateTexture(36197);
                        this.this$0.surfaceTexture = new SurfaceTexture(this.this$0.textureId);
                        SurfaceTexture surfaceTexture = this.this$0.surfaceTexture;
                        if (surfaceTexture == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
                            surfaceTexture = null;
                        }
                        surfaceTexture.setDefaultBufferSize(this.this$0.width, this.this$0.height);
                        SurfaceTexture surfaceTexture2 = this.this$0.surfaceTexture;
                        if (surfaceTexture2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
                            surfaceTexture2 = null;
                        }
                        this.this$0.setSurface(new Surface(surfaceTexture2));
                        this.this$0.logger.info(this.this$0.TAG, "Created surface texture for video source with dimensions " + this.this$0.width + " x " + this.this$0.height);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public /* synthetic */ DefaultSurfaceTextureCaptureSource(Logger logger, int n, int n2, VideoContentHint videoContentHint, EglCoreFactory eglCoreFactory, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            videoContentHint = VideoContentHint.None;
        }
        this(logger, n, n2, videoContentHint, eglCoreFactory);
    }

    @Override
    @NotNull
    public VideoContentHint getContentHint() {
        return this.contentHint;
    }

    @Override
    @NotNull
    public Surface getSurface() {
        Surface surface = this.surface;
        if (surface != null) {
            return surface;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"surface");
        return null;
    }

    public void setSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"<set-?>");
        this.surface = surface;
    }

    @Override
    public int getMinFps() {
        return this.minFps;
    }

    @Override
    public void setMinFps(int n) {
        this.minFps = n;
    }

    @Override
    public void start() {
        this.handler.post(() -> DefaultSurfaceTextureCaptureSource.start$lambda$1(this));
    }

    @Override
    public void setMaxResolution(@NotNull VideoResolution maxResolution) {
        Intrinsics.checkNotNullParameter((Object)((Object)maxResolution), (String)"maxResolution");
    }

    @Override
    public void stop() {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultSurfaceTextureCaptureSource this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultSurfaceTextureCaptureSource.access$getLogger$p(this.this$0).info(DefaultSurfaceTextureCaptureSource.access$getTAG$p(this.this$0), "Setting on frame available listener to null");
                        SurfaceTexture surfaceTexture = DefaultSurfaceTextureCaptureSource.access$getSurfaceTexture$p(this.this$0);
                        if (surfaceTexture == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
                            surfaceTexture = null;
                        }
                        surfaceTexture.setOnFrameAvailableListener(null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void addCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
    }

    @Override
    public void removeCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
    }

    @Override
    public void addVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sinks.add(sink);
    }

    @Override
    public void removeVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sinks.remove(sink);
    }

    @Override
    public void release() {
        this.handler.post(() -> DefaultSurfaceTextureCaptureSource.release$lambda$2(this));
    }

    private final void tryCapturingFrame() {
        if (this.releasePending || !this.pendingAvailableFrame || this.textureBufferInFlight) {
            return;
        }
        this.textureBufferInFlight = true;
        this.pendingAvailableFrame = false;
        SurfaceTexture surfaceTexture = this.surfaceTexture;
        if (surfaceTexture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
            surfaceTexture = null;
        }
        surfaceTexture.updateTexImage();
        float[] transformMatrix = new float[16];
        SurfaceTexture surfaceTexture2 = this.surfaceTexture;
        if (surfaceTexture2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
            surfaceTexture2 = null;
        }
        surfaceTexture2.getTransformMatrix(transformMatrix);
        VideoFrameTextureBuffer buffer = new VideoFrameTextureBuffer(this.width, this.height, this.textureId, GlUtil.INSTANCE.convertToMatrix(transformMatrix), VideoFrameTextureBuffer.Type.TEXTURE_OES, () -> DefaultSurfaceTextureCaptureSource.tryCapturingFrame$lambda$3(this));
        SurfaceTexture surfaceTexture3 = this.surfaceTexture;
        if (surfaceTexture3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
            surfaceTexture3 = null;
        }
        long alignedTimestamp = this.timestampAligner.translateTimestamp(surfaceTexture3.getTimestamp());
        VideoFrame frame = new VideoFrame(alignedTimestamp, buffer, null, 4, null);
        Iterator<VideoSink> $this$forEach$iv = this.sinks.iterator();
        boolean $i$f$forEach = false;
        Iterator<VideoSink> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            VideoSink element$iv;
            VideoSink it = element$iv = iterator.next();
            boolean bl = false;
            it.onVideoFrameReceived(frame);
        }
        frame.release();
        if (this.getMinFps() > 0) {
            this.lastAlignedTimestamp = alignedTimestamp;
            float resendDelayMs = (float)this.RESEND_DELAY_BUFFER_MS + 1.0f / (float)this.getMinFps() * (float)1000;
            this.handler.postDelayed(() -> DefaultSurfaceTextureCaptureSource.tryCapturingFrame$lambda$5(alignedTimestamp, this), (long)resendDelayMs);
        }
    }

    private final void onFrameReleased() {
        this.handler.post(() -> DefaultSurfaceTextureCaptureSource.onFrameReleased$lambda$6(this));
    }

    private final void completeRelease() {
        int[] nArray = new int[]{this.textureId};
        GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        SurfaceTexture surfaceTexture = this.surfaceTexture;
        if (surfaceTexture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
            surfaceTexture = null;
        }
        surfaceTexture.release();
        this.getSurface().release();
        EglCore eglCore = this.eglCore;
        if (eglCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
            eglCore = null;
        }
        eglCore.release();
        this.timestampAligner.dispose();
        this.logger.info(this.TAG, "Finished releasing surface texture capture source");
        this.handler.getLooper().quit();
    }

    private static final void start$lambda$1$lambda$0(DefaultSurfaceTextureCaptureSource this$0, SurfaceTexture it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.pendingAvailableFrame = true;
        this$0.tryCapturingFrame();
    }

    private static final void start$lambda$1(DefaultSurfaceTextureCaptureSource this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SurfaceTexture surfaceTexture = this$0.surfaceTexture;
        if (surfaceTexture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
            surfaceTexture = null;
        }
        surfaceTexture.setOnFrameAvailableListener(arg_0 -> DefaultSurfaceTextureCaptureSource.start$lambda$1$lambda$0(this$0, arg_0), this$0.handler);
    }

    private static final void release$lambda$2(DefaultSurfaceTextureCaptureSource this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.logger.info(this$0.TAG, "Releasing surface texture capture source");
        if (!this$0.textureBufferInFlight) {
            this$0.completeRelease();
        } else {
            this$0.releasePending = true;
        }
    }

    private static final void tryCapturingFrame$lambda$3(DefaultSurfaceTextureCaptureSource this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onFrameReleased();
    }

    private static final void tryCapturingFrame$lambda$5(long $alignedTimestamp, DefaultSurfaceTextureCaptureSource this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Long l = this$0.lastAlignedTimestamp;
        if (l != null && $alignedTimestamp == l) {
            this$0.pendingAvailableFrame = true;
            this$0.tryCapturingFrame();
        }
    }

    private static final void onFrameReleased$lambda$6(DefaultSurfaceTextureCaptureSource this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.textureBufferInFlight = false;
        if (this$0.releasePending) {
            this$0.completeRelease();
        } else {
            this$0.tryCapturingFrame();
        }
    }
}

