/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.analytics;

import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingHistoryEvent;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingHistoryEventName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingStatsCollector;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016J\u0018\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010 \u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/analytics/DefaultMeetingStatsCollector;", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "historyEvents", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingHistoryEvent;", "maxVideoTileCount", "", "meetingStartConnectingTimeMs", "", "meetingStartTimeMs", "poorConnectionCount", "retryCount", "addMeetingHistoryEvent", "", "historyEventName", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingHistoryEventName;", "timestampMs", "getMeetingHistory", "", "getMeetingStatsEventAttributes", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributeName;", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributes;", "incrementPoorConnectionCount", "incrementRetryCount", "resetMeetingStats", "updateMaxVideoTile", "videoTileCount", "updateMeetingStartConnectingTimeMs", "updateMeetingStartTimeMs", "amazon-chime-sdk_release"})
public final class DefaultMeetingStatsCollector
implements MeetingStatsCollector {
    @NotNull
    private final Logger logger;
    private long meetingStartConnectingTimeMs;
    private long meetingStartTimeMs;
    private int retryCount;
    private int poorConnectionCount;
    private int maxVideoTileCount;
    @NotNull
    private final List<MeetingHistoryEvent> historyEvents;

    public DefaultMeetingStatsCollector(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.historyEvents = new ArrayList();
    }

    @Override
    public void incrementRetryCount() {
        int n = this.retryCount;
        this.retryCount = n + 1;
    }

    @Override
    public void incrementPoorConnectionCount() {
        int n = this.poorConnectionCount;
        this.poorConnectionCount = n + 1;
    }

    @Override
    public void updateMaxVideoTile(int videoTileCount) {
        this.maxVideoTileCount = RangesKt.coerceAtLeast((int)videoTileCount, (int)this.maxVideoTileCount);
    }

    @Override
    public void updateMeetingStartConnectingTimeMs() {
        this.meetingStartConnectingTimeMs = Calendar.getInstance().getTimeInMillis();
    }

    @Override
    public void updateMeetingStartTimeMs() {
        this.meetingStartTimeMs = Calendar.getInstance().getTimeInMillis();
    }

    @Override
    public void resetMeetingStats() {
        this.meetingStartConnectingTimeMs = 0L;
        this.meetingStartTimeMs = 0L;
        this.retryCount = 0;
        this.poorConnectionCount = 0;
        this.maxVideoTileCount = 0;
    }

    @Override
    @NotNull
    public Map<EventAttributeName, Object> getMeetingStatsEventAttributes() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.maxVideoTileCount), (Object)this.maxVideoTileCount), TuplesKt.to((Object)((Object)EventAttributeName.retryCount), (Object)this.retryCount), TuplesKt.to((Object)((Object)EventAttributeName.poorConnectionCount), (Object)this.poorConnectionCount), TuplesKt.to((Object)((Object)EventAttributeName.meetingDurationMs), (Object)(this.meetingStartTimeMs == 0L ? 0L : Calendar.getInstance().getTimeInMillis() - this.meetingStartTimeMs)), TuplesKt.to((Object)((Object)EventAttributeName.meetingStartDurationMs), (Object)(this.meetingStartTimeMs == 0L ? 0L : this.meetingStartTimeMs - this.meetingStartConnectingTimeMs))};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Override
    public void addMeetingHistoryEvent(@NotNull MeetingHistoryEventName historyEventName, long timestampMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)historyEventName), (String)"historyEventName");
        this.historyEvents.add(new MeetingHistoryEvent(historyEventName, timestampMs));
    }

    @Override
    @NotNull
    public List<MeetingHistoryEvent> getMeetingHistory() {
        return this.historyEvents;
    }
}

