/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.utils;

import android.graphics.Point;
import android.view.View;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoScalingType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J&\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/VideoLayoutMeasure;", "", "()V", "scalingType", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoScalingType;", "getScalingType", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoScalingType;", "setScalingType", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoScalingType;)V", "getDisplaySize", "Landroid/graphics/Point;", "minVisibleFraction", "", "videoAspectRatio", "maxDisplayWidth", "", "maxDisplayHeight", "measure", "widthSpec", "heightSpec", "frameWidth", "frameHeight", "amazon-chime-sdk_release"})
public final class VideoLayoutMeasure {
    @NotNull
    private VideoScalingType scalingType = VideoScalingType.AspectFill;

    @NotNull
    public final VideoScalingType getScalingType() {
        return this.scalingType;
    }

    public final void setScalingType(@NotNull VideoScalingType videoScalingType) {
        Intrinsics.checkNotNullParameter((Object)((Object)videoScalingType), (String)"<set-?>");
        this.scalingType = videoScalingType;
    }

    @NotNull
    public final Point measure(int widthSpec, int heightSpec, int frameWidth, int frameHeight) {
        int maxWidth = View.getDefaultSize((int)Integer.MAX_VALUE, (int)widthSpec);
        int maxHeight = View.getDefaultSize((int)Integer.MAX_VALUE, (int)heightSpec);
        if (frameWidth == 0 || frameHeight == 0 || maxWidth == 0 || maxHeight == 0) {
            return new Point(maxWidth, maxHeight);
        }
        float frameAspect = (float)frameWidth / (float)frameHeight;
        Point layoutSize = this.getDisplaySize(this.scalingType.getVisibleFraction(), frameAspect, maxWidth, maxHeight);
        if (View.MeasureSpec.getMode((int)widthSpec) == 0x40000000) {
            layoutSize.x = maxWidth;
        }
        if (View.MeasureSpec.getMode((int)heightSpec) == 0x40000000) {
            layoutSize.y = maxHeight;
        }
        return layoutSize;
    }

    private final Point getDisplaySize(float minVisibleFraction, float videoAspectRatio, int maxDisplayWidth, int maxDisplayHeight) {
        if (minVisibleFraction == 0.0f || videoAspectRatio == 0.0f) {
            return new Point(maxDisplayWidth, maxDisplayHeight);
        }
        int width = RangesKt.coerceAtMost((int)maxDisplayWidth, (int)MathKt.roundToInt((float)((float)maxDisplayHeight / minVisibleFraction * videoAspectRatio)));
        int height = RangesKt.coerceAtMost((int)maxDisplayHeight, (int)MathKt.roundToInt((float)((float)maxDisplayWidth / minVisibleFraction / videoAspectRatio)));
        return new Point(width, height);
    }
}

