/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.utils;

import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributesKt;
import com.amazonaws.services.chime.sdk.meetings.ingestion.IngestionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.DeviceUtils;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionConfiguration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004j\u0002`\u0006J\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/EventAttributesUtils;", "", "()V", "getCommonAttributes", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributeName;", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributes;", "meetingSessionConfiguration", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "getIngestionMetadata", "", "", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionMetadata;", "ingestionConfiguration", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionConfiguration;", "amazon-chime-sdk_release"})
public final class EventAttributesUtils {
    @NotNull
    public static final EventAttributesUtils INSTANCE = new EventAttributesUtils();

    private EventAttributesUtils() {
    }

    @NotNull
    public final Map<String, Object> getIngestionMetadata(@NotNull IngestionConfiguration ingestionConfiguration) {
        Intrinsics.checkNotNullParameter((Object)ingestionConfiguration, (String)"ingestionConfiguration");
        Map metadata = MapsKt.toMutableMap(ingestionConfiguration.getClientConfiguration().getMetadataAttributes());
        metadata.putAll(EventAttributesKt.toStringKeyMap(this.getCommonAttributes()));
        return metadata;
    }

    @NotNull
    public final Map<EventAttributeName, Object> getCommonAttributes(@NotNull MeetingSessionConfiguration meetingSessionConfiguration) {
        Map<EventAttributeName, Object> attributes;
        block0: {
            Intrinsics.checkNotNullParameter((Object)meetingSessionConfiguration, (String)"meetingSessionConfiguration");
            attributes = this.getCommonAttributes();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.meetingId), (Object)meetingSessionConfiguration.getMeetingId()), TuplesKt.to((Object)((Object)EventAttributeName.attendeeId), (Object)meetingSessionConfiguration.getCredentials().getAttendeeId()), TuplesKt.to((Object)((Object)EventAttributeName.externalUserId), (Object)meetingSessionConfiguration.getCredentials().getExternalUserId())};
            attributes.putAll(MapsKt.mapOf((Pair[])pairArray));
            String string = meetingSessionConfiguration.getExternalMeetingId();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            attributes.put(EventAttributeName.externalMeetingId, it);
        }
        return attributes;
    }

    @NotNull
    public final Map<EventAttributeName, Object> getCommonAttributes() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.deviceName), (Object)DeviceUtils.Companion.getDeviceName()), TuplesKt.to((Object)((Object)EventAttributeName.deviceManufacturer), (Object)DeviceUtils.Companion.getDeviceManufacturer()), TuplesKt.to((Object)((Object)EventAttributeName.deviceModel), (Object)DeviceUtils.Companion.getDeviceModel()), TuplesKt.to((Object)((Object)EventAttributeName.mediaSdkVersion), (Object)DeviceUtils.Companion.getMediaSDKVersion()), TuplesKt.to((Object)((Object)EventAttributeName.osName), (Object)DeviceUtils.Companion.getOsName()), TuplesKt.to((Object)((Object)EventAttributeName.osVersion), (Object)DeviceUtils.Companion.getOsVersion()), TuplesKt.to((Object)((Object)EventAttributeName.sdkName), (Object)DeviceUtils.Companion.getSdkName()), TuplesKt.to((Object)((Object)EventAttributeName.sdkVersion), (Object)DeviceUtils.Companion.getSdkVersion())};
        Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
        Intrinsics.checkNotNull((Object)attributes, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName, kotlin.Any>{ com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributesKt.EventAttributes }");
        return TypeIntrinsics.asMutableMap((Object)attributes);
    }
}

