/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.os.Build;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/DNSServerUtils;", "", "()V", "TAG", "", "getAvailableDnsServers", "", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)[Ljava/lang/String;", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDNSServerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DNSServerUtils.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/utils/DNSServerUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,50:1\n37#2,2:51\n*S KotlinDebug\n*F\n+ 1 DNSServerUtils.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/utils/DNSServerUtils\n*L\n47#1:51,2\n*E\n"})
public final class DNSServerUtils {
    @NotNull
    public static final DNSServerUtils INSTANCE = new DNSServerUtils();
    @NotNull
    private static final String TAG = "DNSServerUtils";

    private DNSServerUtils() {
    }

    @NotNull
    public final String[] getAvailableDnsServers(@NotNull Context context, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        List dnsHosts = new ArrayList();
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Object object = context.getSystemService("connectivity");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
                ConnectivityManager connectivityManager = (ConnectivityManager)object;
                LinkProperties linkProperties = connectivityManager.getLinkProperties(connectivityManager.getActiveNetwork());
                if (linkProperties != null) {
                    Object[] objectArray = linkProperties.getDnsServers();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getDnsServers(...)");
                    Object[] addresses = objectArray;
                    int n = addresses.size();
                    for (int i = 0; i < n; ++i) {
                        String string = ((InetAddress)addresses.get(i)).getHostAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
                        if (!(((CharSequence)string).length() > 0)) continue;
                        String string2 = ((InetAddress)addresses.get(i)).getHostAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHostAddress(...)");
                        dnsHosts.add(string2);
                    }
                    logger.info(TAG, "Get " + dnsHosts.size() + " DNS addresses.");
                }
            }
            catch (Exception e) {
                logger.error(TAG, "Failed to get active DNS address.");
            }
        } else {
            try {
                Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
                Object[] objectArray = new Class[]{String.class};
                Method method = SystemProperties.getMethod("get", (Class<?>[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getMethod(...)");
                Method method2 = method;
                objectArray = new String[]{"net.dns1", "net.dns2"};
                for (Object name : objectArray) {
                    Object[] objectArray2 = new Object[]{name};
                    Object object = method2.invoke(null, objectArray2);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    String value = (String)object;
                    if (!(((CharSequence)value).length() > 0)) continue;
                    dnsHosts.add(value);
                }
                logger.info(TAG, "Get " + dnsHosts.size() + " DNS addresses,");
            }
            catch (Exception e) {
                logger.error(TAG, "Failed to get active DNS address.");
            }
        }
        Collection $this$toTypedArray$iv = dnsHosts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }
}

