/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database;

import android.content.ContentValues;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.DirtyEventDao;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.DirtyMeetingEventItem;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.EventTypeConverters;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.SDKEvent;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.DatabaseManager;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.DatabaseTable;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 H\u0016J\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0 H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020$0 2\u0006\u0010&\u001a\u00020\u001eH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DirtyEventSQLiteDao;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/DirtyEventDao;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseTable;", "databaseManager", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseManager;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "eventTypeConverter", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/EventTypeConverters;", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseManager;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/EventTypeConverters;)V", "TAG", "", "columns", "", "getColumns", "()Ljava/util/Map;", "dataColumnName", "dataColumnType", "idColumnName", "idColumnType", "primaryKey", "Lkotlin/Pair;", "getPrimaryKey", "()Lkotlin/Pair;", "tableName", "getTableName", "()Ljava/lang/String;", "ttlColumnName", "ttlColumnType", "deleteDirtyEventsByIds", "", "ids", "", "insertDirtyMeetingEventItems", "", "dirtyEvents", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/DirtyMeetingEventItem;", "listDirtyMeetingEventItems", "size", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDirtyEventSQLiteDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirtyEventSQLiteDao.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DirtyEventSQLiteDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1549#2:63\n1620#2,3:64\n1549#2:67\n1620#2,3:68\n*S KotlinDebug\n*F\n+ 1 DirtyEventSQLiteDao.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DirtyEventSQLiteDao\n*L\n39#1:63\n39#1:64,3\n53#1:67\n53#1:68,3\n*E\n"})
public final class DirtyEventSQLiteDao
implements DirtyEventDao,
DatabaseTable {
    @NotNull
    private final DatabaseManager databaseManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final EventTypeConverters eventTypeConverter;
    @NotNull
    private final String tableName;
    @NotNull
    private final String TAG;
    @NotNull
    private final String idColumnName;
    @NotNull
    private final String dataColumnName;
    @NotNull
    private final String ttlColumnName;
    @NotNull
    private final String idColumnType;
    @NotNull
    private final String dataColumnType;
    @NotNull
    private final String ttlColumnType;

    public DirtyEventSQLiteDao(@NotNull DatabaseManager databaseManager, @NotNull Logger logger, @NotNull EventTypeConverters eventTypeConverter) {
        Intrinsics.checkNotNullParameter((Object)databaseManager, (String)"databaseManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)eventTypeConverter, (String)"eventTypeConverter");
        this.databaseManager = databaseManager;
        this.logger = logger;
        this.eventTypeConverter = eventTypeConverter;
        this.tableName = "DirtyEvents";
        this.TAG = "DirtyEventSQLiteDao";
        this.idColumnName = "id";
        this.dataColumnName = "data";
        this.ttlColumnName = "ttl";
        this.idColumnType = "TEXT";
        this.dataColumnType = "TEXT NOT NULL";
        this.ttlColumnType = "INTEGER NOT NULL";
        this.databaseManager.createTable(this);
    }

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @NotNull
    public Map<String, String> getColumns() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.dataColumnName, (Object)this.dataColumnType), TuplesKt.to((Object)this.ttlColumnName, (Object)this.ttlColumnType)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public Pair<String, String> getPrimaryKey() {
        return TuplesKt.to((Object)this.idColumnName, (Object)this.idColumnType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DirtyMeetingEventItem> listDirtyMeetingEventItems(int size) {
        void $this$mapTo$iv$iv;
        List<Map<String, Object>> retrievedDataList = this.databaseManager.query(this.getTableName(), size);
        Iterable $this$map$iv = retrievedDataList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void retrievedData;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = retrievedData.get(this.idColumnName);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            String string = (String)v;
            Object v2 = retrievedData.get(this.dataColumnName);
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
            SDKEvent sDKEvent = this.eventTypeConverter.toMeetingEvent((String)v2);
            Object v3 = retrievedData.get(this.ttlColumnName);
            Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.Long");
            collection.add(new DirtyMeetingEventItem(string, sDKEvent, (Long)v3));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public int deleteDirtyEventsByIds(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.databaseManager.delete(this.getTableName(), this.idColumnName, ids);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean insertDirtyMeetingEventItems(@NotNull List<DirtyMeetingEventItem> dirtyEvents) {
        Collection<ContentValues> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(dirtyEvents, (String)"dirtyEvents");
        Iterable iterable = dirtyEvents;
        String string = this.getTableName();
        DatabaseManager databaseManager = this.databaseManager;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void dirtyEvent;
            ContentValues contentValues;
            DirtyMeetingEventItem dirtyMeetingEventItem = (DirtyMeetingEventItem)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ContentValues $this$insertDirtyMeetingEventItems_u24lambda_u242_u24lambda_u241 = contentValues = new ContentValues();
            boolean bl2 = false;
            $this$insertDirtyMeetingEventItems_u24lambda_u242_u24lambda_u241.put(this.idColumnName, dirtyEvent.getId());
            $this$insertDirtyMeetingEventItems_u24lambda_u242_u24lambda_u241.put(this.dataColumnName, this.eventTypeConverter.fromMeetingEvent(dirtyEvent.getData()));
            $this$insertDirtyMeetingEventItems_u24lambda_u242_u24lambda_u241.put(this.ttlColumnName, Long.valueOf(dirtyEvent.getTtl()));
            collection.add(contentValues);
        }
        collection = (List)destination$iv$iv;
        return databaseManager.insert(string, (List<ContentValues>)collection);
    }
}

