/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.ingestion;

import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.SDKEvent;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/EventTypeConverters;", "", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "TAG", "", "gson", "Lcom/google/gson/Gson;", "fromMeetingEvent", "event", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/SDKEvent;", "toMeetingEvent", "data", "amazon-chime-sdk_release"})
public final class EventTypeConverters {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String TAG;
    @NotNull
    private final Gson gson;

    public EventTypeConverters(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.TAG = "EventTypeConverters";
        JsonDeserializer deserializer2 = (arg_0, arg_1, arg_2) -> EventTypeConverters._init_$lambda$0(this, arg_0, arg_1, arg_2);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)SDKEvent.class), (Object)deserializer2);
        Gson gson = gsonBuilder.create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        this.gson = gson;
    }

    @NotNull
    public final SDKEvent toMeetingEvent(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = this.gson.fromJson(data, SDKEvent.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (SDKEvent)object;
    }

    @NotNull
    public final String fromMeetingEvent(@NotNull SDKEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = this.gson.toJson((Object)event);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    private static final SDKEvent _init_$lambda$0(EventTypeConverters this$0, JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsonObject jsonObject = json.getAsJsonObject();
        String name = "";
        Map attributes = null;
        try {
            String string = jsonObject.get("name").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            name = string;
        }
        catch (Exception exception) {
            this$0.logger.error(this$0.TAG, "Unable to deserialize name " + exception);
        }
        try {
            Type attributeType2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
            attributes = (Map)new Gson().fromJson(jsonObject.get("eventAttributes"), attributeType2);
        }
        catch (Exception exception) {
            this$0.logger.error(this$0.TAG, "Unable to deserialize eventAttributes " + exception);
        }
        if ((map = attributes) == null) {
            map = MapsKt.emptyMap();
        }
        return new SDKEvent(name, map);
    }
}

