/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.ingestion;

import com.amazonaws.services.chime.sdk.meetings.ingestion.EventClientConfiguration;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventClientType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/ingestion/MeetingEventClientConfiguration;", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventClientConfiguration;", "eventClientJoinToken", "", "meetingId", "attendeeId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAttendeeId", "()Ljava/lang/String;", "getEventClientJoinToken", "getMeetingId", "metadataAttributes", "", "", "getMetadataAttributes", "()Ljava/util/Map;", "tag", "getTag", "type", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventClientType;", "getType", "()Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventClientType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "amazon-chime-sdk_release"})
public final class MeetingEventClientConfiguration
implements EventClientConfiguration {
    @NotNull
    private final String eventClientJoinToken;
    @NotNull
    private final String meetingId;
    @NotNull
    private final String attendeeId;
    @NotNull
    private final EventClientType type;
    @NotNull
    private final String tag;
    @NotNull
    private final Map<String, Object> metadataAttributes;

    public MeetingEventClientConfiguration(@NotNull String eventClientJoinToken, @NotNull String meetingId, @NotNull String attendeeId) {
        Intrinsics.checkNotNullParameter((Object)eventClientJoinToken, (String)"eventClientJoinToken");
        Intrinsics.checkNotNullParameter((Object)meetingId, (String)"meetingId");
        Intrinsics.checkNotNullParameter((Object)attendeeId, (String)"attendeeId");
        this.eventClientJoinToken = eventClientJoinToken;
        this.meetingId = meetingId;
        this.attendeeId = attendeeId;
        this.type = EventClientType.Meet;
        this.tag = "Meet";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"meetingId", (Object)this.meetingId), TuplesKt.to((Object)"attendeeId", (Object)this.attendeeId)};
        this.metadataAttributes = MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public String getEventClientJoinToken() {
        return this.eventClientJoinToken;
    }

    @NotNull
    public final String getMeetingId() {
        return this.meetingId;
    }

    @NotNull
    public final String getAttendeeId() {
        return this.attendeeId;
    }

    @Override
    @NotNull
    public EventClientType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public Map<String, Object> getMetadataAttributes() {
        return this.metadataAttributes;
    }

    @NotNull
    public final String component1() {
        return this.eventClientJoinToken;
    }

    @NotNull
    public final String component2() {
        return this.meetingId;
    }

    @NotNull
    public final String component3() {
        return this.attendeeId;
    }

    @NotNull
    public final MeetingEventClientConfiguration copy(@NotNull String eventClientJoinToken, @NotNull String meetingId, @NotNull String attendeeId) {
        Intrinsics.checkNotNullParameter((Object)eventClientJoinToken, (String)"eventClientJoinToken");
        Intrinsics.checkNotNullParameter((Object)meetingId, (String)"meetingId");
        Intrinsics.checkNotNullParameter((Object)attendeeId, (String)"attendeeId");
        return new MeetingEventClientConfiguration(eventClientJoinToken, meetingId, attendeeId);
    }

    public static /* synthetic */ MeetingEventClientConfiguration copy$default(MeetingEventClientConfiguration meetingEventClientConfiguration, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = meetingEventClientConfiguration.eventClientJoinToken;
        }
        if ((n & 2) != 0) {
            string2 = meetingEventClientConfiguration.meetingId;
        }
        if ((n & 4) != 0) {
            string3 = meetingEventClientConfiguration.attendeeId;
        }
        return meetingEventClientConfiguration.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "MeetingEventClientConfiguration(eventClientJoinToken=" + this.eventClientJoinToken + ", meetingId=" + this.meetingId + ", attendeeId=" + this.attendeeId + ')';
    }

    public int hashCode() {
        int result = this.eventClientJoinToken.hashCode();
        result = result * 31 + this.meetingId.hashCode();
        result = result * 31 + this.attendeeId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MeetingEventClientConfiguration)) {
            return false;
        }
        MeetingEventClientConfiguration meetingEventClientConfiguration = (MeetingEventClientConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.eventClientJoinToken, (Object)meetingEventClientConfiguration.eventClientJoinToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.meetingId, (Object)meetingEventClientConfiguration.meetingId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.attendeeId, (Object)meetingEventClientConfiguration.attendeeId);
    }
}

