/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.opengl.GLES20;
import com.amazonaws.services.chime.cwt.ModelState;
import com.amazonaws.services.chime.cwt.PredictResult;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.ModelShape;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.SegmentationProcessor;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.DefaultGlVideoFrameDrawer;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlUtil;
import com.amazonaws.services.chime.sdk.meetings.utils.GlTextureFrameBufferHelper;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.video.JniUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J \u0010$\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010%\u001a\u00020 J\u0016\u0010&\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u001bJ\u0010\u0010(\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u0006\u0010)\u001a\u00020*R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/BackgroundFilterVideoFrameProcessor;", "", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "context", "Landroid/content/Context;", "tag", "", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Landroid/content/Context;Ljava/lang/String;)V", "TAG", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "cachedHeight", "", "cachedWidth", "channels", "defaultInputModelShape", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/ModelShape;", "modelStateMsg", "predictMsg", "rectDrawer", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer;", "segmentationProcessor", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/SegmentationProcessor;", "textureFrameBuffer", "Lcom/amazonaws/services/chime/sdk/meetings/utils/GlTextureFrameBufferHelper;", "drawImageWithMask", "Landroid/graphics/Bitmap;", "scaledInputBitmap", "outputBitmap", "filteredBitmap", "getByteBufferFromInputVideoFrame", "Ljava/nio/ByteBuffer;", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "getInputBitmap", "getProcessedFrame", "rgbaData", "getScaledInputBitmap", "inputBitmap", "getSegmentationMask", "release", "", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nBackgroundFilterVideoFrameProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundFilterVideoFrameProcessor.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/BackgroundFilterVideoFrameProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
public final class BackgroundFilterVideoFrameProcessor {
    @NotNull
    private final Logger logger;
    @NotNull
    private final DefaultGlVideoFrameDrawer rectDrawer;
    @NotNull
    private final GlTextureFrameBufferHelper textureFrameBuffer;
    @NotNull
    private final String TAG;
    @NotNull
    private final SegmentationProcessor segmentationProcessor;
    @Nullable
    private String modelStateMsg;
    @Nullable
    private String predictMsg;
    private int cachedWidth;
    private int cachedHeight;
    @NotNull
    private final ModelShape defaultInputModelShape;
    private final int channels;
    @NotNull
    private final Bitmap.Config bitmapConfig;

    public BackgroundFilterVideoFrameProcessor(@NotNull Logger logger, @NotNull Context context, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.logger = logger;
        this.rectDrawer = new DefaultGlVideoFrameDrawer();
        this.textureFrameBuffer = new GlTextureFrameBufferHelper(6408);
        this.TAG = tag;
        this.segmentationProcessor = new SegmentationProcessor(context);
        this.defaultInputModelShape = new ModelShape(0, 0, 0, 0, 0, 31, null);
        this.channels = this.defaultInputModelShape.getChannels();
        this.bitmapConfig = Bitmap.Config.ARGB_8888;
    }

    @NotNull
    public final Bitmap getInputBitmap(@NotNull VideoFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        ByteBuffer rgbaData = this.getByteBufferFromInputVideoFrame(frame);
        Bitmap bitmap = Bitmap.createBitmap((int)frame.getRotatedWidth(), (int)frame.getRotatedHeight(), (Bitmap.Config)this.bitmapConfig);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        Bitmap inputBitmap = bitmap;
        inputBitmap.copyPixelsFromBuffer((Buffer)rgbaData);
        JniUtil.nativeFreeByteBuffer((ByteBuffer)rgbaData);
        return inputBitmap;
    }

    @NotNull
    public final ByteBuffer getByteBufferFromInputVideoFrame(@NotNull VideoFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.textureFrameBuffer.setSize(frame.getRotatedWidth(), frame.getRotatedHeight());
        GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer.getFrameBufferId());
        Matrix matrix = new Matrix();
        matrix.preTranslate(0.5f, 0.5f);
        matrix.preScale(1.0f, -1.0f);
        matrix.preTranslate(-0.5f, -0.5f);
        this.rectDrawer.drawFrame(frame, 0, 0, frame.getRotatedWidth(), frame.getRotatedHeight(), matrix);
        ByteBuffer rgbaData = JniUtil.nativeAllocateByteBuffer((int)(frame.getRotatedWidth() * frame.getRotatedHeight() * this.channels));
        GLES20.glReadPixels((int)0, (int)0, (int)frame.getRotatedWidth(), (int)frame.getRotatedHeight(), (int)6408, (int)5121, (Buffer)rgbaData);
        GlUtil.INSTANCE.checkGlError("glReadPixels");
        Intrinsics.checkNotNull((Object)rgbaData);
        return rgbaData;
    }

    @NotNull
    public final Bitmap getScaledInputBitmap(@NotNull VideoFrame frame, @NotNull Bitmap inputBitmap) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        int scaledHeight = this.defaultInputModelShape.getHeight();
        int scaledWidth = this.defaultInputModelShape.getWidth();
        if (frame.getRotation().getDegrees() % 180 == 0) {
            scaledHeight = this.defaultInputModelShape.getWidth();
            scaledWidth = this.defaultInputModelShape.getHeight();
        }
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)inputBitmap, (int)scaledWidth, (int)scaledHeight, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createScaledBitmap(...)");
        return bitmap;
    }

    @NotNull
    public final VideoFrame getProcessedFrame(@NotNull VideoFrame frame, @Nullable Bitmap filteredBitmap, @NotNull ByteBuffer rgbaData) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)rgbaData, (String)"rgbaData");
        Ref.ObjectRef filteredByteBuffer = new Ref.ObjectRef();
        if (filteredBitmap == null) {
            filteredByteBuffer.element = rgbaData;
        } else {
            ByteBuffer byteBuffer = JniUtil.nativeAllocateByteBuffer((int)(frame.getRotatedWidth() * frame.getRotatedHeight() * this.channels));
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nativeAllocateByteBuffer(...)");
            filteredByteBuffer.element = byteBuffer;
            filteredBitmap.copyPixelsToBuffer((Buffer)filteredByteBuffer.element);
            ((ByteBuffer)filteredByteBuffer.element).position(0);
        }
        VideoFrameRGBABuffer rgbaBuffer = new VideoFrameRGBABuffer(frame.getRotatedWidth(), frame.getRotatedHeight(), (ByteBuffer)filteredByteBuffer.element, frame.getRotatedWidth() * this.channels, () -> BackgroundFilterVideoFrameProcessor.getProcessedFrame$lambda$0(filteredByteBuffer));
        return new VideoFrame(frame.getTimestampNs(), rgbaBuffer, null, 4, null);
    }

    @Nullable
    public final Bitmap getSegmentationMask(@NotNull Bitmap scaledInputBitmap) {
        Intrinsics.checkNotNullParameter((Object)scaledInputBitmap, (String)"scaledInputBitmap");
        if (scaledInputBitmap.getWidth() != this.cachedWidth || scaledInputBitmap.getHeight() != this.cachedHeight) {
            String it;
            this.cachedWidth = scaledInputBitmap.getWidth();
            this.cachedHeight = scaledInputBitmap.getHeight();
            this.segmentationProcessor.initialize(scaledInputBitmap.getWidth(), scaledInputBitmap.getHeight(), this.defaultInputModelShape);
            ModelState modelState = this.segmentationProcessor.getModelState();
            if (modelState != ModelState.LOADING && modelState != ModelState.LOADED && this.modelStateMsg == null) {
                String string = this.modelStateMsg = "Failed to load model with model state " + modelState;
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    this.logger.error(this.TAG, it);
                }
            } else if (this.modelStateMsg == null) {
                String string = this.modelStateMsg = "Model State " + modelState;
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    this.logger.info(this.TAG, it);
                }
            }
        }
        ByteBuffer inputBuffer = this.segmentationProcessor.getInputBuffer();
        scaledInputBitmap.copyPixelsToBuffer((Buffer)inputBuffer);
        PredictResult predictResult = this.segmentationProcessor.predict();
        if (predictResult == PredictResult.ERROR && this.predictMsg == null) {
            String string = this.predictMsg = "Error segmenting background from foreground";
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.logger.error(this.TAG, it);
            }
        }
        ByteBuffer outputBuffer = this.segmentationProcessor.getOutputBuffer();
        Bitmap bitmap = Bitmap.createBitmap((int)scaledInputBitmap.getWidth(), (int)scaledInputBitmap.getHeight(), (Bitmap.Config)this.bitmapConfig);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        Bitmap outputBitmap = bitmap;
        outputBitmap.copyPixelsFromBuffer((Buffer)outputBuffer);
        return outputBitmap;
    }

    @Nullable
    public final Bitmap drawImageWithMask(@NotNull Bitmap scaledInputBitmap, @Nullable Bitmap outputBitmap, @Nullable Bitmap filteredBitmap) {
        block4: {
            Canvas canvas;
            Canvas canvas2;
            Intrinsics.checkNotNullParameter((Object)scaledInputBitmap, (String)"scaledInputBitmap");
            Paint paint = new Paint();
            PorterDuff.Mode paintMode = PorterDuff.Mode.SRC_IN;
            paint.setXfermode((Xfermode)new PorterDuffXfermode(paintMode));
            Bitmap bitmap = outputBitmap;
            if (bitmap != null) {
                Bitmap it = bitmap;
                boolean bl = false;
                canvas2 = new Canvas(it);
            } else {
                canvas2 = null;
            }
            Canvas canvas3 = canvas = canvas2;
            if (canvas3 != null) {
                canvas3.drawBitmap(scaledInputBitmap, 0.0f, 0.0f, paint);
            }
            paintMode = PorterDuff.Mode.DST_OVER;
            paint.setXfermode((Xfermode)new PorterDuffXfermode(paintMode));
            if (filteredBitmap == null) break block4;
            Canvas canvas4 = canvas;
            if (canvas4 != null) {
                canvas4.drawBitmap(filteredBitmap, 0.0f, 0.0f, paint);
            }
        }
        return outputBitmap;
    }

    public final void release() {
        this.rectDrawer.release();
        this.textureFrameBuffer.release();
    }

    private static final void getProcessedFrame$lambda$0(Ref.ObjectRef $filteredByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)$filteredByteBuffer, (String)"$filteredByteBuffer");
        JniUtil.nativeFreeByteBuffer((ByteBuffer)((ByteBuffer)$filteredByteBuffer.element));
    }
}

