/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.utils;

import com.amazonaws.services.chime.sdk.meetings.internal.video.TURNCredentials;
import com.amazonaws.services.chime.sdk.meetings.internal.video.TURNRequestParams;
import com.amazonaws.services.chime.sdk.meetings.utils.DefaultModality;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/TURNRequestUtils;", "", "()V", "CONTENT_TYPE", "", "CONTENT_TYPE_HEADER", "MEETING_ID_KEY", "SYSPROP_USER_AGENT", "TAG", "TOKEN_HEADER", "TOKEN_KEY", "USER_AGENT_HEADER", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "doTurnRequest", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/TURNCredentials;", "turnRequestParams", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/TURNRequestParams;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/video/TURNRequestParams;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "amazon-chime-sdk_release"})
public final class TURNRequestUtils {
    private static final String TOKEN_HEADER = "X-Chime-Auth-Token";
    private static final String SYSPROP_USER_AGENT = "http.agent";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE = "application/json";
    private static final String MEETING_ID_KEY = "meetingId";
    private static final String TOKEN_KEY = "_aws_wt_session";
    private static final String TAG = "TURNRequestUtils";
    private static final CoroutineDispatcher ioDispatcher;
    public static final TURNRequestUtils INSTANCE;

    @Nullable
    public final Object doTurnRequest(@NotNull TURNRequestParams turnRequestParams, @NotNull Logger logger, @NotNull Continuation<? super TURNCredentials> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)ioDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TURNCredentials>, Object>(logger, turnRequestParams, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ Logger $logger;
            final /* synthetic */ TURNRequestParams $turnRequestParams;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        TURNCredentials tURNCredentials;
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$withContext = this.p$;
                        try {
                            TURNCredentials tURNCredentials2;
                            StringBuffer response = new StringBuffer();
                            this.$logger.info(TURNRequestUtils.access$getTAG$p(TURNRequestUtils.INSTANCE), "Making TURN Request");
                            URLConnection uRLConnection = new URL(this.$turnRequestParams.getTurnControlUrl()).openConnection();
                            if (uRLConnection == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
                            }
                            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                            boolean bl = false;
                            boolean bl2 = false;
                            HttpURLConnection $this$with = httpURLConnection;
                            boolean bl3 = false;
                            $this$with.setRequestMethod("POST");
                            $this$with.setDoInput(true);
                            $this$with.setDoOutput(true);
                            $this$with.addRequestProperty(TURNRequestUtils.access$getTOKEN_HEADER$p(TURNRequestUtils.INSTANCE), TURNRequestUtils.access$getTOKEN_KEY$p(TURNRequestUtils.INSTANCE) + '=' + new DefaultModality(this.$turnRequestParams.getJoinToken()).base());
                            $this$with.setRequestProperty(TURNRequestUtils.access$getCONTENT_TYPE_HEADER$p(TURNRequestUtils.INSTANCE), TURNRequestUtils.access$getCONTENT_TYPE$p(TURNRequestUtils.INSTANCE));
                            String user_agent = System.getProperty(TURNRequestUtils.access$getSYSPROP_USER_AGENT$p(TURNRequestUtils.INSTANCE));
                            this.$logger.info(TURNRequestUtils.access$getTAG$p(TURNRequestUtils.INSTANCE), "User Agent while doing TURN request is " + user_agent);
                            $this$with.setRequestProperty(TURNRequestUtils.access$getUSER_AGENT_HEADER$p(TURNRequestUtils.INSTANCE), user_agent);
                            BufferedWriter out = new BufferedWriter(new OutputStreamWriter($this$with.getOutputStream()));
                            out.write(new JSONObject().put(TURNRequestUtils.access$getMEETING_ID_KEY$p(TURNRequestUtils.INSTANCE), (Object)this.$turnRequestParams.getMeetingId()).toString());
                            out.flush();
                            out.close();
                            Closeable closeable = new BufferedReader(new InputStreamReader($this$with.getInputStream()));
                            boolean bl4 = false;
                            Throwable throwable = null;
                            try {
                                BufferedReader it = (BufferedReader)closeable;
                                boolean bl5 = false;
                                String inputLine = it.readLine();
                                while (inputLine != null) {
                                    response.append(inputLine);
                                    inputLine = it.readLine();
                                }
                                it.close();
                                it = Unit.INSTANCE;
                            }
                            catch (Throwable it) {
                                throwable = it;
                                throw it;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            if ($this$with.getResponseCode() == 200) {
                                this.$logger.info(TURNRequestUtils.access$getTAG$p(TURNRequestUtils.INSTANCE), "TURN Request Success");
                                JSONObject responseObject = new JSONObject(response.toString());
                                JSONArray jsonArray = responseObject.getJSONArray("uris");
                                String[] uris = new String[jsonArray.length()];
                                int it = 0;
                                int n = jsonArray.length();
                                while (it < n) {
                                    void i2;
                                    uris[i2] = jsonArray.getString((int)i2);
                                    ++i2;
                                }
                                String string = responseObject.getString("username");
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"responseObject.getString\u2026DENTIALS_RESULT_USERNAME)");
                                String string2 = responseObject.getString("password");
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"responseObject.getString\u2026DENTIALS_RESULT_PASSWORD)");
                                String string3 = responseObject.getString("ttl");
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"responseObject.getString\u2026N_CREDENTIALS_RESULT_TTL)");
                                tURNCredentials2 = new TURNCredentials(string, string2, string3, uris);
                            } else {
                                this.$logger.error(TURNRequestUtils.access$getTAG$p(TURNRequestUtils.INSTANCE), "TURN Request got error with Response code: " + $this$with.getResponseCode());
                                tURNCredentials2 = null;
                            }
                            tURNCredentials = tURNCredentials2;
                        }
                        catch (Exception exception) {
                            this.$logger.error(TURNRequestUtils.access$getTAG$p(TURNRequestUtils.INSTANCE), "Exception while doing TURN Request: " + exception);
                            tURNCredentials = null;
                        }
                        return tURNCredentials;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$logger = logger;
                this.$turnRequestParams = tURNRequestParams;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super TURNCredentials>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private TURNRequestUtils() {
    }

    static {
        TURNRequestUtils tURNRequestUtils;
        INSTANCE = tURNRequestUtils = new TURNRequestUtils();
        TOKEN_HEADER = TOKEN_HEADER;
        SYSPROP_USER_AGENT = SYSPROP_USER_AGENT;
        USER_AGENT_HEADER = USER_AGENT_HEADER;
        CONTENT_TYPE_HEADER = CONTENT_TYPE_HEADER;
        CONTENT_TYPE = CONTENT_TYPE;
        MEETING_ID_KEY = MEETING_ID_KEY;
        TOKEN_KEY = TOKEN_KEY;
        TAG = TAG;
        ioDispatcher = Dispatchers.getIO();
    }

    public static final /* synthetic */ String access$getTAG$p(TURNRequestUtils $this) {
        TURNRequestUtils tURNRequestUtils = $this;
        return TAG;
    }

    public static final /* synthetic */ String access$getTOKEN_HEADER$p(TURNRequestUtils $this) {
        TURNRequestUtils tURNRequestUtils = $this;
        return TOKEN_HEADER;
    }

    public static final /* synthetic */ String access$getTOKEN_KEY$p(TURNRequestUtils $this) {
        TURNRequestUtils tURNRequestUtils = $this;
        return TOKEN_KEY;
    }

    public static final /* synthetic */ String access$getCONTENT_TYPE_HEADER$p(TURNRequestUtils $this) {
        TURNRequestUtils tURNRequestUtils = $this;
        return CONTENT_TYPE_HEADER;
    }

    public static final /* synthetic */ String access$getCONTENT_TYPE$p(TURNRequestUtils $this) {
        TURNRequestUtils tURNRequestUtils = $this;
        return CONTENT_TYPE;
    }

    public static final /* synthetic */ String access$getSYSPROP_USER_AGENT$p(TURNRequestUtils $this) {
        TURNRequestUtils tURNRequestUtils = $this;
        return SYSPROP_USER_AGENT;
    }

    public static final /* synthetic */ String access$getUSER_AGENT_HEADER$p(TURNRequestUtils $this) {
        TURNRequestUtils tURNRequestUtils = $this;
        return USER_AGENT_HEADER;
    }

    public static final /* synthetic */ String access$getMEETING_ID_KEY$p(TURNRequestUtils $this) {
        TURNRequestUtils tURNRequestUtils = $this;
        return MEETING_ID_KEY;
    }
}

