/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.utils;

import com.amazonaws.services.chime.sdk.meetings.internal.utils.BackOffRetry;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/DefaultBackOffRetry;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/BackOffRetry;", "maxRetry", "", "backOff", "", "retryableStatusCodes", "", "(IJLjava/util/Set;)V", "currentRetry", "multiplier", "calculateBackOff", "getRetryCount", "incrementRetryCount", "", "isRetryCountLimitReached", "", "isRetryableCode", "responseCode", "amazon-chime-sdk_release"})
public final class DefaultBackOffRetry
implements BackOffRetry {
    private final int multiplier = 1;
    private int currentRetry;
    private final int maxRetry;
    private final long backOff;
    private final Set<Integer> retryableStatusCodes;

    @Override
    public long calculateBackOff() {
        double d = this.multiplier;
        double d2 = this.currentRetry;
        double d3 = this.backOff;
        boolean bl = false;
        double d4 = Math.pow(d, d2);
        return (long)(d3 * d4);
    }

    @Override
    public int getRetryCount() {
        return this.currentRetry;
    }

    @Override
    public boolean isRetryCountLimitReached() {
        return this.maxRetry > this.currentRetry;
    }

    @Override
    public void incrementRetryCount() {
        int n = this.currentRetry;
        this.currentRetry = n + 1;
    }

    @Override
    public boolean isRetryableCode(int responseCode) {
        return this.retryableStatusCodes.isEmpty() || this.retryableStatusCodes.contains(responseCode);
    }

    public DefaultBackOffRetry(int maxRetry, long backOff, @NotNull Set<Integer> retryableStatusCodes) {
        Intrinsics.checkParameterIsNotNull(retryableStatusCodes, (String)"retryableStatusCodes");
        this.maxRetry = maxRetry;
        this.backOff = backOff;
        this.retryableStatusCodes = retryableStatusCodes;
        this.multiplier = 1;
    }

    public /* synthetic */ DefaultBackOffRetry(int n, long l, Set set, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        if ((n2 & 4) != 0) {
            set = new HashSet();
        }
        this(n, l, set);
    }

    public DefaultBackOffRetry() {
        this(0, 0L, null, 7, null);
    }
}

