/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.analytics;

import com.amazonaws.services.chime.sdk.meetings.analytics.DefaultEventAnalyticsController$WhenMappings;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsObserver;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingHistoryEvent;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingHistoryEventName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingStatsCollector;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventReporter;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.SDKEvent;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.EventAttributesUtils;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u0002`\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J,\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u001a\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012j\u0004\u0018\u0001`\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/analytics/DefaultEventAnalyticsController;", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "meetingSessionConfiguration", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "meetingStatsCollector", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;", "eventReporter", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventReporter;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventReporter;)V", "eventAnalyticsObservers", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsObserver;", "addEventAnalyticsObserver", "", "observer", "getCommonEventAttributes", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributeName;", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributes;", "getMeetingHistory", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingHistoryEvent;", "publishEvent", "name", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventName;", "attributes", "pushHistory", "historyEventName", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingHistoryEventName;", "removeEventAnalyticsObserver", "amazon-chime-sdk_release"})
public final class DefaultEventAnalyticsController
implements EventAnalyticsController {
    private Set<EventAnalyticsObserver> eventAnalyticsObservers;
    private final Logger logger;
    private final MeetingSessionConfiguration meetingSessionConfiguration;
    private final MeetingStatsCollector meetingStatsCollector;
    private final EventReporter eventReporter;

    @Override
    public void publishEvent(@NotNull EventName name, @Nullable Map<EventAttributeName, Object> attributes) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)name), (String)"name");
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        long now = calendar.getTimeInMillis();
        this.meetingStatsCollector.addMeetingHistoryEvent(MeetingHistoryEventName.Companion.fromMeetingEvent(name), now);
        Map map = attributes;
        if (map == null) {
            boolean bl = false;
            map = new LinkedHashMap();
        }
        Map eventAttributes = map;
        eventAttributes.put((EventAttributeName)EventAttributeName.timestampMs, now);
        switch (DefaultEventAnalyticsController$WhenMappings.$EnumSwitchMapping$0[name.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                eventAttributes.putAll(this.meetingStatsCollector.getMeetingStatsEventAttributes());
                break;
            }
        }
        EventReporter eventReporter = this.eventReporter;
        if (eventReporter != null) {
            eventReporter.report(new SDKEvent(name, (Map<EventAttributeName, Object>)eventAttributes));
        }
        ObserverUtils.Companion.notifyObserverOnMainThread(this.eventAnalyticsObservers, (Function1)new Function1<EventAnalyticsObserver, Unit>(name, eventAttributes){
            final /* synthetic */ EventName $name;
            final /* synthetic */ Map $eventAttributes;

            public final void invoke(@NotNull EventAnalyticsObserver it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.onEventReceived(this.$name, this.$eventAttributes);
            }
            {
                this.$name = eventName;
                this.$eventAttributes = map;
                super(1);
            }
        });
    }

    @Override
    public void pushHistory(@NotNull MeetingHistoryEventName historyEventName) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)historyEventName), (String)"historyEventName");
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        long currentTimeMs = calendar.getTimeInMillis();
        Map map = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.timestampMs), (Object)currentTimeMs)});
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributes /* = kotlin.collections.MutableMap<com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName, kotlin.Any> */");
        }
        Map eventAttributes = TypeIntrinsics.asMutableMap((Object)map);
        EventReporter eventReporter = this.eventReporter;
        if (eventReporter != null) {
            eventReporter.report(new SDKEvent(historyEventName, (Map<EventAttributeName, Object>)eventAttributes));
        }
        this.meetingStatsCollector.addMeetingHistoryEvent(historyEventName, currentTimeMs);
    }

    @Override
    @NotNull
    public List<MeetingHistoryEvent> getMeetingHistory() {
        return this.meetingStatsCollector.getMeetingHistory();
    }

    @Override
    @NotNull
    public Map<EventAttributeName, Object> getCommonEventAttributes() {
        return EventAttributesUtils.INSTANCE.getCommonAttributes(this.meetingSessionConfiguration);
    }

    @Override
    public void addEventAnalyticsObserver(@NotNull EventAnalyticsObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.eventAnalyticsObservers.add(observer);
    }

    @Override
    public void removeEventAnalyticsObserver(@NotNull EventAnalyticsObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.eventAnalyticsObservers.remove(observer);
    }

    public DefaultEventAnalyticsController(@NotNull Logger logger, @NotNull MeetingSessionConfiguration meetingSessionConfiguration, @NotNull MeetingStatsCollector meetingStatsCollector, @Nullable EventReporter eventReporter) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)meetingSessionConfiguration, (String)"meetingSessionConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)meetingStatsCollector, (String)"meetingStatsCollector");
        this.logger = logger;
        this.meetingSessionConfiguration = meetingSessionConfiguration;
        this.meetingStatsCollector = meetingStatsCollector;
        this.eventReporter = eventReporter;
        this.eventAnalyticsObservers = ConcurrentSet.Companion.createConcurrentSet();
    }

    public /* synthetic */ DefaultEventAnalyticsController(Logger logger, MeetingSessionConfiguration meetingSessionConfiguration, MeetingStatsCollector meetingStatsCollector, EventReporter eventReporter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            eventReporter = null;
        }
        this(logger, meetingSessionConfiguration, meetingStatsCollector, eventReporter);
    }
}

