/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004\u00a8\u0006\f"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/ScreenCaptureResolutionCalculator;", "", "()V", "alignToEven", "", "positiveNumber", "computeTargetSize", "", "displayWidth", "displayHeight", "targetResolutionLong", "targetResolutionShort", "amazon-chime-sdk_release"})
public final class ScreenCaptureResolutionCalculator {
    public final int alignToEven(int positiveNumber) {
        return positiveNumber & ~1;
    }

    @NotNull
    public final int[] computeTargetSize(int displayWidth, int displayHeight, int targetResolutionLong, int targetResolutionShort) {
        boolean resolutionOverConstraint;
        boolean bl = false;
        int displayResolutionShort = Math.min(displayWidth, displayHeight);
        boolean bl2 = false;
        int displayResolutionLong = Math.max(displayWidth, displayHeight);
        int scaledWidth = 0;
        int scaledHeight = 0;
        boolean bl3 = resolutionOverConstraint = displayResolutionShort > targetResolutionShort || displayResolutionLong > targetResolutionLong;
        if (resolutionOverConstraint) {
            double resolutionShortScale = (double)displayResolutionShort / (double)targetResolutionShort;
            double resolutionLongScale = (double)displayResolutionLong / (double)targetResolutionLong;
            if (resolutionShortScale > resolutionLongScale) {
                if (displayResolutionShort == displayWidth) {
                    scaledWidth = targetResolutionShort;
                    scaledHeight = (int)((double)displayHeight / resolutionShortScale);
                } else {
                    scaledHeight = targetResolutionShort;
                    scaledWidth = (int)((double)displayWidth / resolutionShortScale);
                }
            } else if (displayResolutionLong == displayWidth) {
                scaledWidth = targetResolutionLong;
                scaledHeight = (int)((double)displayHeight / resolutionLongScale);
            } else {
                scaledHeight = targetResolutionLong;
                scaledWidth = (int)((double)displayWidth / resolutionLongScale);
            }
        } else {
            scaledWidth = displayWidth;
            scaledHeight = displayHeight;
        }
        int[] resolutions = new int[]{scaledWidth, scaledHeight};
        return resolutions;
    }
}

