/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.ingestion;

import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.SDKEvent;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/EventTypeConverters;", "", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "TAG", "", "gson", "Lcom/google/gson/Gson;", "fromMeetingEvent", "event", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/SDKEvent;", "toMeetingEvent", "data", "amazon-chime-sdk_release"})
public final class EventTypeConverters {
    private final String TAG = "EventTypeConverters";
    private final Gson gson;
    private final Logger logger;

    @NotNull
    public final SDKEvent toMeetingEvent(@NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Object object = this.gson.fromJson(data, SDKEvent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(data, SDKEvent::class.java)");
        return (SDKEvent)object;
    }

    @NotNull
    public final String fromMeetingEvent(@NotNull SDKEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String string = this.gson.toJson((Object)event);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(event)");
        return string;
    }

    public EventTypeConverters(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.TAG = "EventTypeConverters";
        JsonDeserializer deserializer2 = (JsonDeserializer)new JsonDeserializer<SDKEvent>(this){
            final /* synthetic */ EventTypeConverters this$0;

            @NotNull
            public final SDKEvent deserialize(JsonElement json, Type $noName_1, JsonDeserializationContext $noName_2) {
                JsonElement jsonElement = json;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"json");
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String name = "";
                Map attributes = null;
                try {
                    JsonElement jsonElement2 = jsonObject.get("name");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"jsonObject[\"name\"]");
                    String string = jsonElement2.getAsString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonObject[\"name\"].asString");
                    name = string;
                }
                catch (Exception exception) {
                    EventTypeConverters.access$getLogger$p(this.this$0).error(EventTypeConverters.access$getTAG$p(this.this$0), "Unable to deserialize name " + exception);
                }
                try {
                    Type attributeType2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
                    attributes = (Map)new Gson().fromJson(jsonObject.get("eventAttributes"), attributeType2);
                }
                catch (Exception exception) {
                    EventTypeConverters.access$getLogger$p(this.this$0).error(EventTypeConverters.access$getTAG$p(this.this$0), "Unable to deserialize eventAttributes " + exception);
                }
                String string = name;
                Map map = attributes;
                if (map == null) {
                    String string2 = string;
                    boolean bl = false;
                    Map map2 = MapsKt.emptyMap();
                    string = string2;
                    map = map2;
                }
                Map map3 = map;
                String string3 = string;
                return new SDKEvent(string3, map3);
            }
            {
                this.this$0 = eventTypeConverters;
            }
        };
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)SDKEvent.class), (Object)deserializer2);
        Gson gson = gsonBuilder.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"gsonBuilder.create()");
        this.gson = gson;
    }

    public static final /* synthetic */ Logger access$getLogger$p(EventTypeConverters $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getTAG$p(EventTypeConverters $this) {
        return $this.TAG;
    }
}

