/*
 * Decompiled with CFR 0.152.
 */
package software.aws.awsprototypingsdk.cdkgraph;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.aws.awsprototypingsdk.cdkgraph.$Module;
import software.aws.awsprototypingsdk.cdkgraph.FlagEnum;
import software.aws.awsprototypingsdk.cdkgraph.IBaseEntityDataProps;
import software.aws.awsprototypingsdk.cdkgraph.IBaseEntityProps;
import software.aws.awsprototypingsdk.cdkgraph.ISerializableEntity;
import software.aws.awsprototypingsdk.cdkgraph.Store;
import software.constructs.MetadataEntry;

@Jsii(module=$Module.class, fqn="@aws-prototyping-sdk/cdk-graph.BaseEntity")
public abstract class BaseEntity
extends JsiiObject
implements ISerializableEntity {
    protected BaseEntity(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BaseEntity(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected BaseEntity(@NotNull IBaseEntityProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addAttribute(@NotNull String key, @NotNull Object value) {
        Kernel.call((Object)this, (String)"addAttribute", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    public void addFlag(@NotNull FlagEnum flag) {
        Kernel.call((Object)this, (String)"addFlag", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(flag, "flag is required")});
    }

    public void addMetadata(@NotNull String metadataType, @NotNull Object data) {
        Kernel.call((Object)this, (String)"addMetadata", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(metadataType, "metadataType is required"), data});
    }

    public void addTag(@NotNull String key, @NotNull String value) {
        Kernel.call((Object)this, (String)"addTag", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")});
    }

    public void applyData(@NotNull IBaseEntityDataProps data, @Nullable Boolean overwrite, @Nullable Boolean applyFlags) {
        Kernel.call((Object)this, (String)"applyData", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(data, "data is required"), overwrite, applyFlags});
    }

    public void applyData(@NotNull IBaseEntityDataProps data, @Nullable Boolean overwrite) {
        Kernel.call((Object)this, (String)"applyData", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(data, "data is required"), overwrite});
    }

    public void applyData(@NotNull IBaseEntityDataProps data) {
        Kernel.call((Object)this, (String)"applyData", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(data, "data is required")});
    }

    @NotNull
    public List<MetadataEntry> findMetadata(@NotNull String metadataType) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"findMetadata", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(MetadataEntry.class)), (Object[])new Object[]{Objects.requireNonNull(metadataType, "metadataType is required")}));
    }

    @NotNull
    public Object getAttribute(@NotNull String key) {
        return Kernel.call((Object)this, (String)"getAttribute", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required")});
    }

    @Nullable
    public String getTag(@NotNull String key) {
        return (String)Kernel.call((Object)this, (String)"getTag", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required")});
    }

    @NotNull
    public Boolean hasAttribute(@NotNull String key, @Nullable Object value) {
        return (Boolean)Kernel.call((Object)this, (String)"hasAttribute", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    @NotNull
    public Boolean hasAttribute(@NotNull String key) {
        return (Boolean)Kernel.call((Object)this, (String)"hasAttribute", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required")});
    }

    @NotNull
    public Boolean hasFlag(@NotNull FlagEnum flag) {
        return (Boolean)Kernel.call((Object)this, (String)"hasFlag", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(flag, "flag is required")});
    }

    @NotNull
    public Boolean hasMetadata(@NotNull String metadataType, @NotNull Object data) {
        return (Boolean)Kernel.call((Object)this, (String)"hasMetadata", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(metadataType, "metadataType is required"), data});
    }

    @NotNull
    public Boolean hasTag(@NotNull String key, @Nullable String value) {
        return (Boolean)Kernel.call((Object)this, (String)"hasTag", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    @NotNull
    public Boolean hasTag(@NotNull String key) {
        return (Boolean)Kernel.call((Object)this, (String)"hasTag", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required")});
    }

    public abstract void mutateDestroy(@Nullable Boolean var1);

    public abstract void mutateDestroy();

    public void setAttribute(@NotNull String key, @NotNull Object value) {
        Kernel.call((Object)this, (String)"setAttribute", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    public void setTag(@NotNull String key, @NotNull String value) {
        Kernel.call((Object)this, (String)"setTag", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")});
    }

    @NotNull
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"attributes", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public List<FlagEnum> getFlags() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"flags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(FlagEnum.class))));
    }

    @NotNull
    public Boolean getIsDestroyed() {
        return (Boolean)Kernel.get((Object)this, (String)"isDestroyed", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getIsMutated() {
        return (Boolean)Kernel.get((Object)this, (String)"isMutated", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public List<MetadataEntry> getMetadata() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"metadata", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(MetadataEntry.class))));
    }

    @NotNull
    public Store getStore() {
        return (Store)Kernel.get((Object)this, (String)"store", (NativeType)NativeType.forClass(Store.class));
    }

    @NotNull
    public Map<String, String> getTags() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getUuid() {
        return (String)Kernel.get((Object)this, (String)"uuid", (NativeType)NativeType.forClass(String.class));
    }
}

