/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.sns;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.AuthorizationErrorException;
import software.amazon.awssdk.services.sns.model.EndpointDisabledException;
import software.amazon.awssdk.services.sns.model.InternalErrorException;
import software.amazon.awssdk.services.sns.model.InvalidParameterException;
import software.amazon.awssdk.services.sns.model.InvalidParameterValueException;
import software.amazon.awssdk.services.sns.model.InvalidSecurityException;
import software.amazon.awssdk.services.sns.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.sns.model.KmsDisabledException;
import software.amazon.awssdk.services.sns.model.KmsInvalidStateException;
import software.amazon.awssdk.services.sns.model.KmsNotFoundException;
import software.amazon.awssdk.services.sns.model.KmsOptInRequiredException;
import software.amazon.awssdk.services.sns.model.KmsThrottlingException;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.NotFoundException;
import software.amazon.awssdk.services.sns.model.PlatformApplicationDisabledException;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sns.model.SnsException;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.payloadoffloading.PayloadStore;
import software.amazon.payloadoffloading.S3BackedPayloadStore;
import software.amazon.payloadoffloading.S3Dao;
import software.amazon.payloadoffloading.Util;
import software.amazon.sns.AmazonSNSExtendedClientBase;
import software.amazon.sns.AmazonSNSExtendedClientUtil;
import software.amazon.sns.SNSExtendedClientConfiguration;

public class AmazonSNSExtendedClient
extends AmazonSNSExtendedClientBase
implements SnsClient {
    static final String USER_AGENT_HEADER = Util.getUserAgentHeader((String)AmazonSNSExtendedClient.class.getSimpleName());
    private static final Log LOGGER = LogFactory.getLog(AmazonSNSExtendedClient.class);
    private PayloadStore payloadStore;
    private SNSExtendedClientConfiguration snsExtendedClientConfiguration;

    public AmazonSNSExtendedClient(SnsClient snsClient) {
        this(snsClient, new SNSExtendedClientConfiguration());
    }

    public AmazonSNSExtendedClient(SnsClient snsClient, SNSExtendedClientConfiguration snsExtendedClientConfiguration) {
        super(snsClient);
        this.snsExtendedClientConfiguration = snsExtendedClientConfiguration;
        S3Dao s3Dao = new S3Dao(this.snsExtendedClientConfiguration.getS3Client());
        this.payloadStore = new S3BackedPayloadStore(s3Dao, this.snsExtendedClientConfiguration.getS3BucketName());
    }

    public AmazonSNSExtendedClient(SnsClient snsClient, SNSExtendedClientConfiguration snsExtendedClientConfiguration, PayloadStore payloadStore) {
        super(snsClient);
        this.snsExtendedClientConfiguration = snsExtendedClientConfiguration;
        this.payloadStore = payloadStore;
    }

    @Override
    public PublishResponse publish(PublishRequest publishRequest) throws InvalidParameterException, InvalidParameterValueException, InternalErrorException, NotFoundException, EndpointDisabledException, PlatformApplicationDisabledException, AuthorizationErrorException, KmsDisabledException, KmsInvalidStateException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, KmsAccessDeniedException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        if (publishRequest == null || StringUtils.isEmpty((CharSequence)publishRequest.message())) {
            return super.publish(publishRequest);
        }
        if (!StringUtils.isEmpty((CharSequence)publishRequest.messageStructure()) && publishRequest.messageStructure().equals("json")) {
            String errorMessage = "SNS extended client does not support sending JSON messages.";
            LOGGER.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        PublishRequest.Builder publishRequestBuilder = publishRequest.toBuilder();
        publishRequestBuilder.overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().putHeader("User-Agent", USER_AGENT_HEADER)).build());
        publishRequest = (PublishRequest)publishRequestBuilder.build();
        long messageAttributesSize = AmazonSNSExtendedClientUtil.getMsgAttributesSize(publishRequest.messageAttributes());
        long messageBodySize = Util.getStringSizeInBytes((String)publishRequest.message());
        if (!this.shouldExtendedStoreBeUsed(messageAttributesSize + messageBodySize)) {
            return super.publish(publishRequest);
        }
        AmazonSNSExtendedClientUtil.checkMessageAttributes(publishRequest.messageAttributes());
        AmazonSNSExtendedClientUtil.checkSizeOfMessageAttributes(this.snsExtendedClientConfiguration.getPayloadSizeThreshold(), messageAttributesSize);
        PublishRequest clonedPublishRequest = this.copyPublishRequest(publishRequest);
        publishRequest = this.storeMessageInExtendedStore(clonedPublishRequest, messageAttributesSize);
        return super.publish(publishRequest);
    }

    private PublishRequest storeMessageInExtendedStore(PublishRequest publishRequest, long messageAttributeSize) {
        String messageContentStr = publishRequest.message();
        long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        String s3Key = AmazonSNSExtendedClientUtil.getS3keyAttribute(publishRequest.messageAttributes());
        PublishRequest.Builder publishRequestBuilder = publishRequest.toBuilder();
        String largeMessagePointer = s3Key != null ? this.payloadStore.storeOriginalPayload(messageContentStr, s3Key) : this.payloadStore.storeOriginalPayload(messageContentStr);
        publishRequestBuilder.message(largeMessagePointer);
        MessageAttributeValue.Builder messageAttributeValueBuilder = MessageAttributeValue.builder();
        messageAttributeValueBuilder.dataType("Number");
        messageAttributeValueBuilder.stringValue(String.valueOf(messageContentSize));
        MessageAttributeValue messageAttributeValue = (MessageAttributeValue)messageAttributeValueBuilder.build();
        HashMap<String, MessageAttributeValue> attributes = new HashMap<String, MessageAttributeValue>(publishRequest.messageAttributes());
        attributes.put("ExtendedPayloadSize", messageAttributeValue);
        publishRequestBuilder.messageAttributes(attributes);
        AmazonSNSExtendedClientUtil.checkSizeOfMessageAttributes(this.snsExtendedClientConfiguration.getPayloadSizeThreshold(), messageAttributeSize += AmazonSNSExtendedClientUtil.getMessageAttributeSize("ExtendedPayloadSize", messageAttributeValue));
        return (PublishRequest)publishRequestBuilder.build();
    }

    private PublishRequest copyPublishRequest(PublishRequest publishRequest) {
        PublishRequest.Builder publishRequestBuilder = publishRequest.toBuilder();
        HashMap attributes = new HashMap(publishRequest.messageAttributes());
        publishRequestBuilder.messageAttributes(attributes);
        return (PublishRequest)publishRequestBuilder.build();
    }

    private boolean shouldExtendedStoreBeUsed(long totalMessageSize) {
        return this.snsExtendedClientConfiguration.isAlwaysThroughS3() || this.snsExtendedClientConfiguration.isPayloadSupportEnabled() && AmazonSNSExtendedClientUtil.isTotalMessageSizeLargerThanThreshold(this.snsExtendedClientConfiguration.getPayloadSizeThreshold(), totalMessageSize);
    }

    @Override
    public void close() {
        super.close();
        this.snsExtendedClientConfiguration.getS3Client().close();
    }
}

