/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> copyOf(Collection<? extends T> values) {
        return values.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(values));
    }

    public static <T> List<T> of() {
        return Collections.emptyList();
    }

    public static <T> List<T> of(T value) {
        return Collections.singletonList(value);
    }

    @SafeVarargs
    public static <T> List<T> of(T ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }
}

