/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.smithy.utils.BuilderRef;

final class DefaultBuilderRef<T>
implements BuilderRef<T> {
    private final Supplier<T> ctor;
    private final Function<T, T> copyCtor;
    private final Function<T, T> immutableWrapper;
    private final Supplier<T> emptyCtorOptimization;
    private T immutableOwned;
    private T owned;
    private T borrowed;

    DefaultBuilderRef(Supplier<T> ctor, Function<T, T> copyCtor, Function<T, T> immutableWrapper, Supplier<T> emptyCtorOptimization) {
        this.ctor = ctor;
        this.copyCtor = copyCtor;
        this.immutableWrapper = immutableWrapper;
        this.emptyCtorOptimization = emptyCtorOptimization;
    }

    @Override
    public T get() {
        if (this.owned != null) {
            return this.owned;
        }
        if (this.borrowed != null) {
            return this.setOwned(this.applyCopyCtor(this.borrowed));
        }
        return this.setOwned(this.applyCtor());
    }

    @Override
    public T peek() {
        if (this.immutableOwned != null) {
            return this.immutableOwned;
        }
        if (this.owned != null) {
            this.immutableOwned = this.applyImmutableWrapper(this.owned);
            return this.immutableOwned;
        }
        if (this.borrowed != null) {
            return this.borrowed;
        }
        if (this.emptyCtorOptimization != null) {
            return this.applyEmptyCtorOptimization();
        }
        this.setOwned(this.applyCtor());
        return this.peek();
    }

    @Override
    public T copy() {
        if (this.owned != null) {
            T result = this.peek();
            this.setOwned(null);
            this.borrowed = result;
            return result;
        }
        if (this.borrowed != null) {
            return this.applyImmutableWrapper(this.applyCopyCtor(this.borrowed));
        }
        if (this.emptyCtorOptimization != null) {
            return this.applyEmptyCtorOptimization();
        }
        this.borrowed = this.applyImmutableWrapper(this.applyCtor());
        return this.borrowed;
    }

    @Override
    public boolean hasValue() {
        return this.owned != null || this.borrowed != null;
    }

    @Override
    public void clear() {
        this.setOwned(null);
    }

    private T setOwned(T value) {
        this.owned = value;
        this.immutableOwned = null;
        this.borrowed = null;
        return value;
    }

    private T applyCtor() {
        return Objects.requireNonNull(this.ctor.get(), "BuilderRef 'ctor' must not return null");
    }

    private T applyCopyCtor(T value) {
        return Objects.requireNonNull(this.copyCtor.apply(value), "BuilderRef 'copyCtor' must not return null");
    }

    private T applyImmutableWrapper(T value) {
        return Objects.requireNonNull(this.immutableWrapper.apply(value), "BuilderRef 'immutableWrapper' must not return null");
    }

    private T applyEmptyCtorOptimization() {
        return Objects.requireNonNull(this.emptyCtorOptimization.get(), "BuilderRef 'emptyCtorOptimization' must not return null");
    }
}

