/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class SetUtils {
    private SetUtils() {
    }

    public static <T> Set<T> copyOf(Collection<? extends T> values) {
        return values.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<T>(values));
    }

    public static <T> Set<T> orderedCopyOf(Collection<? extends T> values) {
        return values.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<T>(values));
    }

    public static Set<String> caseInsensitiveCopyOf(Collection<? extends String> values) {
        TreeSet<? extends String> caseInsensitiveSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveSet.addAll(Objects.requireNonNull(values));
        return Collections.unmodifiableSet(caseInsensitiveSet);
    }

    public static <T> Set<T> of() {
        return Collections.emptySet();
    }

    public static <T> Set<T> of(T value) {
        return Collections.singleton(value);
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... values) {
        HashSet result = new HashSet(values.length);
        Collections.addAll(result, values);
        return Collections.unmodifiableSet(result);
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet);
    }
}

