/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.function.BiConsumer;
import software.amazon.smithy.utils.AbstractCodeWriter;
import software.amazon.smithy.utils.CodeSection;

public interface CodeInterceptor<S extends CodeSection, W extends AbstractCodeWriter<W>> {
    public Class<S> sectionType();

    default public boolean isIntercepted(S section) {
        return true;
    }

    public void write(W var1, String var2, S var3);

    public static <S extends CodeSection, W extends AbstractCodeWriter<W>> CodeInterceptor<S, W> appender(final Class<S> type, final BiConsumer<W, S> appender) {
        return new Appender<S, W>(){

            @Override
            public void append(W writer, S section) {
                appender.accept(writer, section);
            }

            @Override
            public Class<S> sectionType() {
                return type;
            }
        };
    }

    public static <W extends AbstractCodeWriter<W>> CodeInterceptor<CodeSection, W> forName(final String sectionName, final BiConsumer<W, String> consumer) {
        return new CodeInterceptor<CodeSection, W>(){

            @Override
            public Class<CodeSection> sectionType() {
                return CodeSection.class;
            }

            @Override
            public boolean isIntercepted(CodeSection section) {
                return section.sectionName().equals(sectionName);
            }

            @Override
            public void write(W writer, String previousText, CodeSection section) {
                consumer.accept(writer, previousText);
            }
        };
    }

    public static interface Prepender<S extends CodeSection, W extends AbstractCodeWriter<W>>
    extends CodeInterceptor<S, W> {
        @Override
        default public void write(W writer, String previousText, S section) {
            this.prepend(writer, section);
            if (!previousText.isEmpty()) {
                ((AbstractCodeWriter)writer).writeInlineWithNoFormatting(previousText);
            }
        }

        public void prepend(W var1, S var2);
    }

    public static interface Appender<S extends CodeSection, W extends AbstractCodeWriter<W>>
    extends CodeInterceptor<S, W> {
        @Override
        default public void write(W writer, String previousText, S section) {
            if (!previousText.isEmpty()) {
                ((AbstractCodeWriter)writer).writeInlineWithNoFormatting(previousText);
            }
            this.append(writer, section);
        }

        public void append(W var1, S var2);
    }
}

