/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class OptionalUtils {
    private OptionalUtils() {
    }

    public static <T> Optional<T> or(Optional<T> value, Supplier<Optional<? extends T>> supplier) {
        return value.isPresent() ? value : supplier.get();
    }

    public static <T> Stream<T> stream(Optional<T> value) {
        return value.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> void ifPresentOrElse(Optional<T> value, Consumer<T> action, Runnable emptyAction) {
        if (value.isPresent()) {
            action.accept(value.get());
        } else {
            emptyAction.run();
        }
    }
}

