/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.utils.SimpleParser;

public final class MediaType {
    private final String value;
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    private MediaType(String value, String type, String subtype, Map<String, String> parameters) {
        this.value = value;
        this.type = type;
        this.subtype = subtype;
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    public static MediaType from(String value) {
        Parser parser = new Parser(value);
        parser.parse();
        return new MediaType(parser.expression(), parser.type, parser.subtype, parser.parameters);
    }

    public static boolean isJson(String mediaType) {
        MediaType type = MediaType.from(mediaType);
        return type.getType().equals("application") && type.getSubtypeWithoutSuffix().equals("json") || type.getSuffix().filter(s -> s.equals("json")).isPresent();
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getSubtypeWithoutSuffix() {
        int position = this.subtype.lastIndexOf(43);
        return position == -1 ? this.getSubtype() : this.subtype.substring(0, position);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Optional<String> getSuffix() {
        int position = this.subtype.lastIndexOf(43);
        return position == -1 || position == this.subtype.length() - 1 ? Optional.empty() : Optional.of(this.subtype.substring(position + 1));
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaType)) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return mediaType.type.equals(this.type) && mediaType.subtype.equals(this.subtype) && mediaType.parameters.equals(this.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype, this.parameters);
    }

    private static final class Parser
    extends SimpleParser {
        private static final Set<Character> TOKEN;
        private String type;
        private String subtype;
        private final Map<String, String> parameters = new LinkedHashMap<String, String>();

        Parser(String value) {
            super(value);
        }

        private void parse() {
            this.type = this.parseToken().toLowerCase(Locale.US);
            this.expect('/');
            this.subtype = this.parseToken().toLowerCase(Locale.US);
            this.ws();
            while (!this.eof()) {
                this.expect(';');
                this.ws();
                String name = this.parseToken().toLowerCase(Locale.US);
                this.expect('=');
                String value = this.peek() == '\"' ? this.parseQuotedString() : this.parseToken();
                this.parameters.put(name, value);
                this.ws();
            }
        }

        private String parseToken() {
            int start = this.position();
            this.consumeUntilNoLongerMatches(TOKEN::contains);
            if (start == this.position()) {
                char[] chars = new char[TOKEN.size()];
                int i = 0;
                for (Character character : TOKEN) {
                    chars[i++] = character.charValue();
                }
                this.expect(chars);
            }
            return this.sliceFrom(start);
        }

        private String parseQuotedString() {
            char next;
            StringBuilder result = new StringBuilder();
            this.expect('\"');
            while (!this.eof() && (next = this.peek()) != '\"') {
                this.skip();
                if (next == '\\') {
                    if (this.eof()) {
                        throw this.syntax("Expected character after escape");
                    }
                    result.append(this.peek());
                    this.skip();
                    continue;
                }
                result.append(next);
            }
            this.expect('\"');
            return result.toString();
        }

        static {
            char c;
            TOKEN = new LinkedHashSet<Character>();
            TOKEN.add(Character.valueOf('!'));
            TOKEN.add(Character.valueOf('#'));
            TOKEN.add(Character.valueOf('$'));
            TOKEN.add(Character.valueOf('%'));
            TOKEN.add(Character.valueOf('&'));
            TOKEN.add(Character.valueOf('\''));
            TOKEN.add(Character.valueOf('*'));
            TOKEN.add(Character.valueOf('+'));
            TOKEN.add(Character.valueOf('-'));
            TOKEN.add(Character.valueOf('.'));
            TOKEN.add(Character.valueOf('^'));
            TOKEN.add(Character.valueOf('_'));
            TOKEN.add(Character.valueOf('`'));
            TOKEN.add(Character.valueOf('|'));
            TOKEN.add(Character.valueOf('~'));
            for (c = '0'; c <= '9'; c = (char)(c + 1)) {
                TOKEN.add(Character.valueOf(c));
            }
            for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                TOKEN.add(Character.valueOf(c));
            }
            for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                TOKEN.add(Character.valueOf(c));
            }
        }
    }
}

