/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class IoUtils {
    private static final int BUFFER_SIZE = 4096;

    private IoUtils() {
    }

    public static byte[] toByteArray(InputStream is) {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int n;
            byte[] b = new byte[4096];
            while ((n = is.read(b)) != -1) {
                output.write(b, 0, n);
            }
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        output.close();
        return byArray;
    }

    public static String toUtf8String(InputStream is) {
        return new String(IoUtils.toByteArray(is), StandardCharsets.UTF_8);
    }

    public static String readUtf8File(String path) {
        return IoUtils.readUtf8File(Paths.get(path, new String[0]));
    }

    public static String readUtf8File(Path path) {
        try {
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

