/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits.eventstream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.EventStreamIndex;
import software.amazon.smithy.model.knowledge.EventStreamInfo;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.node.TimestampValidationStrategy;
import software.amazon.smithy.protocoltests.traits.ProtocolTestValidationUtils;
import software.amazon.smithy.protocoltests.traits.eventstream.Event;
import software.amazon.smithy.protocoltests.traits.eventstream.EventStreamTestCase;
import software.amazon.smithy.protocoltests.traits.eventstream.EventStreamTestsTrait;
import software.amazon.smithy.protocoltests.traits.eventstream.EventType;
import software.amazon.smithy.utils.ListUtils;

public final class EventStreamTestsTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape shape : model.getOperationShapesWithTrait(EventStreamTestsTrait.class)) {
            EventStreamTestsTrait trait = (EventStreamTestsTrait)shape.expectTrait(EventStreamTestsTrait.class);
            List<EventStreamTestCase> cases = trait.getTestCases();
            for (int i = 0; i < cases.size(); ++i) {
                EventStreamTestCase testCase = cases.get(i);
                events.addAll(this.validateTestCase(model, shape, trait, testCase, i));
            }
        }
        return events;
    }

    private List<ValidationEvent> validateTestCase(Model model, OperationShape operation, EventStreamTestsTrait trait, EventStreamTestCase testCase, int testCaseIndex) {
        EventStreamIndex eventStreamIndex = EventStreamIndex.of((Model)model);
        Optional inputStream = eventStreamIndex.getInputInfo((ToShapeId)operation);
        Optional outputStream = eventStreamIndex.getOutputInfo((ToShapeId)operation);
        ArrayList<ValidationEvent> validationEvents = new ArrayList<ValidationEvent>();
        if (testCase.getInitialRequestParams().isPresent()) {
            NodeValidationVisitor inputValidator = this.createVisitor(testCase.getInitialRequestParams().get(), model, (Shape)operation, testCaseIndex + ".initialRequestParams");
            validationEvents.addAll((Collection)model.expectShape(operation.getInputShape()).accept((ShapeVisitor)inputValidator));
        }
        if (testCase.getInitialRequestShape().isPresent()) {
            NodeValidationVisitor initialRequestValidator = this.createVisitor(testCase.getInitialRequest().orElseGet(Node::objectNode), model, (Shape)operation, testCaseIndex + ".initialRequest");
            validationEvents.addAll((Collection)model.expectShape(testCase.getInitialRequestShape().get()).accept((ShapeVisitor)initialRequestValidator));
        }
        if (testCase.getInitialResponseParams().isPresent()) {
            NodeValidationVisitor outputValidator = this.createVisitor(testCase.getInitialResponseParams().get(), model, (Shape)operation, testCaseIndex + ".initialResponseParams");
            validationEvents.addAll((Collection)model.expectShape(operation.getOutputShape()).accept((ShapeVisitor)outputValidator));
        }
        if (testCase.getInitialResponseShape().isPresent()) {
            NodeValidationVisitor initialResponseValidator = this.createVisitor(testCase.getInitialResponse().orElseGet(Node::objectNode), model, (Shape)operation, testCaseIndex + ".initialResponse");
            validationEvents.addAll((Collection)model.expectShape(testCase.getInitialResponseShape().get()).accept((ShapeVisitor)initialResponseValidator));
        }
        if (testCase.getVendorParamsShape().isPresent()) {
            NodeValidationVisitor vendorParamsValidator = this.createVisitor(testCase.getVendorParams().orElseGet(Node::objectNode), model, (Shape)operation, testCaseIndex + ".vendorParams");
            validationEvents.addAll((Collection)model.expectShape(testCase.getVendorParamsShape().get()).accept((ShapeVisitor)vendorParamsValidator));
        }
        List<Event> events = testCase.getEvents();
        for (int i = 0; i < events.size(); ++i) {
            Event event = events.get(i);
            String eventContextSuffix = String.format("%s.events.%s", testCaseIndex, i);
            if (event.getParams().isPresent()) {
                String message;
                String paramsContextSuffix = eventContextSuffix + ".params";
                NodeValidationVisitor paramsValidator = this.createVisitor(event.getParams().get(), model, (Shape)operation, paramsContextSuffix);
                if (event.getType().equals((Object)EventType.REQUEST)) {
                    if (!inputStream.isPresent()) {
                        message = String.format("%s.%s: Invalid request event for operation %s that has no input stream.", EventStreamTestsTrait.ID, eventContextSuffix, operation.getId());
                        validationEvents.add(this.error((Shape)operation, (FromSourceLocation)trait, message));
                    } else {
                        validationEvents.addAll((Collection)((EventStreamInfo)inputStream.get()).getEventStreamTarget().accept((ShapeVisitor)paramsValidator));
                    }
                } else if (event.getType().equals((Object)EventType.RESPONSE)) {
                    if (!outputStream.isPresent()) {
                        message = String.format("%s.%s: Invalid response event for operation %s that has no output stream.", EventStreamTestsTrait.ID, eventContextSuffix, operation.getId());
                        validationEvents.add(this.error((Shape)operation, (FromSourceLocation)trait, message, eventContextSuffix));
                    } else {
                        validationEvents.addAll((Collection)((EventStreamInfo)outputStream.get()).getEventStreamTarget().accept((ShapeVisitor)paramsValidator));
                    }
                }
            }
            if (event.getBodyMediaType().isPresent()) {
                validationEvents.addAll(this.validateMediaType(operation, (Trait)trait, event, eventContextSuffix));
            }
            if (!event.getVendorParamsShape().isPresent()) continue;
            Shape vendorParamsShape = model.expectShape(event.getVendorParamsShape().get());
            String vendorParamsContextSuffix = String.format("%s.events.%s.vendorParams", testCaseIndex, i);
            NodeValidationVisitor vendorParamsValidator = this.createVisitor(event.getVendorParams().orElseGet(Node::objectNode), model, (Shape)operation, vendorParamsContextSuffix);
            validationEvents.addAll((Collection)vendorParamsShape.accept((ShapeVisitor)vendorParamsValidator));
        }
        if (!(!testCase.getEvents().isEmpty() || testCase.getInitialRequestParams().isPresent() || testCase.getInitialRequest().isPresent() || testCase.getInitialResponseParams().isPresent() || testCase.getInitialResponse().isPresent())) {
            validationEvents.add(this.error((Shape)operation, (FromSourceLocation)trait, String.format("%s.%s: At least one event, an initial request, or an initial response must be set.", EventStreamTestsTrait.ID, testCaseIndex), String.valueOf(testCaseIndex)));
        }
        return validationEvents;
    }

    private List<ValidationEvent> validateMediaType(OperationShape operation, Trait trait, Event event, String eventContextSuffix) {
        if (!event.getBodyMediaType().isPresent()) {
            return Collections.emptyList();
        }
        return ProtocolTestValidationUtils.validateMediaType(event.getBody().orElse(""), event.getBodyMediaType().get()).map(e -> ListUtils.of((Object)this.emitMediaTypeError(operation, trait, eventContextSuffix, event, (Throwable)e))).orElse(Collections.emptyList());
    }

    private ValidationEvent emitMediaTypeError(OperationShape operation, Trait trait, String eventContextSuffix, Event test, Throwable e) {
        return this.danger((Shape)operation, (FromSourceLocation)trait, String.format("%s.%s.body: Invalid %s content: %s", EventStreamTestsTrait.ID, eventContextSuffix, test.getBodyMediaType().orElse(""), e.getMessage()));
    }

    private NodeValidationVisitor createVisitor(ObjectNode value, Model model, Shape shape, String contextSuffix) {
        return NodeValidationVisitor.builder().model(model).eventShapeId(shape.getId()).value((Node)value).startingContext(EventStreamTestsTrait.ID + "." + contextSuffix).eventId(this.getName()).timestampValidationStrategy(TimestampValidationStrategy.FORMAT).addFeature(NodeValidationVisitor.Feature.ALLOW_OPTIONAL_NULLS).build();
    }
}

