/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits.eventstream;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.protocoltests.traits.AppliesTo;
import software.amazon.smithy.protocoltests.traits.TestExpectation;
import software.amazon.smithy.protocoltests.traits.eventstream.Event;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class EventStreamTestCase
implements ToSmithyBuilder<EventStreamTestCase> {
    private final String id;
    private final ShapeId protocol;
    private final ObjectNode initialRequestParams;
    private final ObjectNode initialRequest;
    private final ShapeId initialRequestShape;
    private final ObjectNode initialResponseParams;
    private final ObjectNode initialResponse;
    private final ShapeId initialResponseShape;
    private final List<Event> events;
    private final TestExpectation expectation;
    private final ObjectNode vendorParams;
    private final ShapeId vendorParamsShape;
    private final String documentation;
    private final AppliesTo appliesTo;

    private EventStreamTestCase(Builder builder) {
        this.id = (String)SmithyBuilder.requiredState((String)"id", (Object)builder.id);
        this.protocol = (ShapeId)SmithyBuilder.requiredState((String)"protocol", (Object)builder.protocol);
        this.initialRequestParams = builder.initialRequestParams;
        this.initialRequest = builder.initialRequest;
        this.initialRequestShape = builder.initialRequestShape;
        this.initialResponseParams = builder.initialResponseParams;
        this.initialResponse = builder.initialResponse;
        this.initialResponseShape = builder.initialResponseShape;
        this.events = (List)builder.events.copy();
        this.expectation = builder.expectation;
        this.vendorParams = builder.vendorParams;
        this.vendorParamsShape = builder.vendorParamsShape;
        this.documentation = builder.documentation;
        this.appliesTo = builder.appliesTo;
    }

    public String getId() {
        return this.id;
    }

    public ShapeId getProtocol() {
        return this.protocol;
    }

    public Optional<ObjectNode> getInitialRequestParams() {
        return Optional.ofNullable(this.initialRequestParams);
    }

    public Optional<ObjectNode> getInitialRequest() {
        return Optional.ofNullable(this.initialRequest);
    }

    public Optional<ShapeId> getInitialRequestShape() {
        return Optional.ofNullable(this.initialRequestShape);
    }

    public Optional<ObjectNode> getInitialResponseParams() {
        return Optional.ofNullable(this.initialResponseParams);
    }

    public Optional<ObjectNode> getInitialResponse() {
        return Optional.ofNullable(this.initialResponse);
    }

    public Optional<ShapeId> getInitialResponseShape() {
        return Optional.ofNullable(this.initialResponseShape);
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public TestExpectation getExpectation() {
        return this.expectation;
    }

    public Optional<ObjectNode> getVendorParams() {
        return Optional.ofNullable(this.vendorParams);
    }

    public Optional<ShapeId> getVendorParamsShape() {
        return Optional.ofNullable(this.vendorParamsShape);
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public Optional<AppliesTo> getAppliesTo() {
        return Optional.ofNullable(this.appliesTo);
    }

    public Builder toBuilder() {
        return EventStreamTestCase.builder().id(this.id).protocol(this.protocol).initialRequestParams(this.initialRequestParams).initialRequest(this.initialRequest).initialRequestShape(this.initialRequestShape).initialResponseParams(this.initialResponseParams).initialResponse(this.initialResponse).initialResponseShape(this.initialResponseShape).events(this.events).expectation(this.expectation).vendorParams(this.vendorParams).vendorParamsShape(this.vendorParamsShape).documentation(this.documentation).appliesTo(this.appliesTo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (!(o instanceof EventStreamTestCase)) {
            return false;
        }
        EventStreamTestCase that = (EventStreamTestCase)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.initialRequestParams, that.initialRequestParams) && Objects.equals(this.initialRequest, that.initialRequest) && Objects.equals(this.initialRequestShape, that.initialRequestShape) && Objects.equals(this.initialResponseParams, that.initialResponseParams) && Objects.equals(this.initialResponse, that.initialResponse) && Objects.equals(this.initialResponseShape, that.initialResponseShape) && Objects.equals(this.events, that.events) && Objects.equals(this.expectation, that.expectation) && Objects.equals(this.vendorParams, that.vendorParams) && Objects.equals(this.vendorParamsShape, that.vendorParamsShape) && Objects.equals(this.documentation, that.documentation) && this.appliesTo == that.appliesTo;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.protocol, this.initialRequestParams, this.initialRequest, this.initialRequestShape, this.initialResponseParams, this.initialResponse, this.initialResponseShape, this.events, this.expectation, this.vendorParams, this.vendorParamsShape, this.documentation, this.appliesTo});
    }

    public static final class Builder
    implements SmithyBuilder<EventStreamTestCase> {
        private String id;
        private ShapeId protocol;
        private ObjectNode initialRequestParams;
        private ObjectNode initialRequest;
        private ShapeId initialRequestShape;
        private ObjectNode initialResponseParams;
        private ObjectNode initialResponse;
        private ShapeId initialResponseShape;
        private final BuilderRef<List<Event>> events = BuilderRef.forList();
        private TestExpectation expectation = TestExpectation.success();
        private ObjectNode vendorParams;
        private ShapeId vendorParamsShape;
        private String documentation;
        private AppliesTo appliesTo;

        public EventStreamTestCase build() {
            return new EventStreamTestCase(this);
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder protocol(ShapeId protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder initialRequestParams(ObjectNode initialRequestParams) {
            this.initialRequestParams = initialRequestParams;
            return this;
        }

        public Builder initialRequest(ObjectNode initialRequest) {
            this.initialRequest = initialRequest;
            return this;
        }

        public Builder initialRequestShape(ShapeId initialRequestShape) {
            this.initialRequestShape = initialRequestShape;
            return this;
        }

        public Builder initialResponseParams(ObjectNode initialResponseParams) {
            this.initialResponseParams = initialResponseParams;
            return this;
        }

        public Builder initialResponse(ObjectNode initialResponse) {
            this.initialResponse = initialResponse;
            return this;
        }

        public Builder initialResponseShape(ShapeId initialResponseShape) {
            this.initialResponseShape = initialResponseShape;
            return this;
        }

        public Builder events(List<Event> events) {
            this.events.clear();
            ((List)this.events.get()).addAll(events);
            return this;
        }

        public Builder event(Event event) {
            ((List)this.events.get()).add(event);
            return this;
        }

        public Builder expectation(TestExpectation expectation) {
            this.expectation = expectation;
            return this;
        }

        public Builder vendorParams(ObjectNode vendorParams) {
            this.vendorParams = vendorParams;
            return this;
        }

        public Builder vendorParamsShape(ShapeId vendorParamsShape) {
            this.vendorParamsShape = vendorParamsShape;
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder appliesTo(AppliesTo appliesTo) {
            this.appliesTo = appliesTo;
            return this;
        }
    }
}

