/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits.eventstream;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;

public abstract class EventHeaderValue<T>
implements ToNode {
    private static final Logger LOGGER = Logger.getLogger(EventHeaderValue.class.getName());
    protected final T value;
    private final Type type;

    private EventHeaderValue(Type type, T value) {
        this.type = type;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException("Member boolean not supported for union of type: " + (Object)((Object)this.type));
    }

    public byte asByte() {
        throw new UnsupportedOperationException("Member byte not supported for union of type: " + (Object)((Object)this.type));
    }

    public short asShort() {
        throw new UnsupportedOperationException("Member short not supported for union of type: " + (Object)((Object)this.type));
    }

    public int asInteger() {
        throw new UnsupportedOperationException("Member int not supported for union of type: " + (Object)((Object)this.type));
    }

    public long asLong() {
        throw new UnsupportedOperationException("Member long not supported for union of type: " + (Object)((Object)this.type));
    }

    public byte[] asBlob() {
        throw new UnsupportedOperationException("Member blob not supported for union of type: " + (Object)((Object)this.type));
    }

    public String asString() {
        throw new UnsupportedOperationException("Member string not supported for union of type: " + (Object)((Object)this.type));
    }

    public Instant asTimestamp() {
        throw new UnsupportedOperationException("Member timestamp not supported for union of type: " + (Object)((Object)this.type));
    }

    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.getValue()});
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return Objects.equals(this.getValue(), ((EventHeaderValue)other).getValue());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EventHeaderValue<?> fromNode(Node node) {
        ObjectNode objectNode = node.expectObjectNode();
        Builder builder = EventHeaderValue.builder();
        block10: for (Map.Entry pair : objectNode.getMembers().entrySet()) {
            Node value = (Node)pair.getValue();
            Type headerType = Type.valueOf(((StringNode)pair.getKey()).getValue().toUpperCase(Locale.ENGLISH));
            switch (headerType) {
                case BOOLEAN: {
                    builder.setBoolean(value.expectBooleanNode().getValue());
                    continue block10;
                }
                case BYTE: {
                    builder.setByte(value.expectNumberNode().getValue().byteValue());
                    continue block10;
                }
                case SHORT: {
                    builder.setShort(value.expectNumberNode().getValue().shortValue());
                    continue block10;
                }
                case INTEGER: {
                    builder.setInteger(value.expectNumberNode().getValue().intValue());
                    continue block10;
                }
                case LONG: {
                    builder.setLong(value.expectNumberNode().getValue().longValue());
                    continue block10;
                }
                case BLOB: {
                    builder.setBlob(Base64.getDecoder().decode(value.expectStringNode().getValue()));
                    continue block10;
                }
                case STRING: {
                    builder.setString(value.expectStringNode().getValue());
                    continue block10;
                }
                case TIMESTAMP: {
                    if (value.isNumberNode()) {
                        builder.setTimestamp(value.expectNumberNode().getValue().longValue());
                        continue block10;
                    }
                    builder.setTimestamp(value.expectStringNode().getValue());
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Unexpected header value type: " + (Object)((Object)headerType));
        }
        return builder.build();
    }

    public static enum Type {
        BOOLEAN,
        BYTE,
        SHORT,
        INTEGER,
        LONG,
        BLOB,
        STRING,
        TIMESTAMP;

    }

    public static final class Builder
    implements SmithyBuilder<EventHeaderValue<?>> {
        private EventHeaderValue<?> value;

        public EventHeaderValue<?> build() {
            return Objects.requireNonNull(this.value);
        }

        public Builder setBoolean(boolean value) {
            return this.setValue(new BooleanMember(value));
        }

        public Builder setByte(byte value) {
            return this.setValue(new ByteMember(value));
        }

        public Builder setShort(short value) {
            return this.setValue(new ShortMember(value));
        }

        public Builder setInteger(int value) {
            return this.setValue(new IntegerMember(value));
        }

        public Builder setLong(long value) {
            return this.setValue(new LongMember(value));
        }

        public Builder setBlob(byte[] value) {
            return this.setValue(new BlobMember(value));
        }

        public Builder setBlob(String value) {
            return this.setValue(new BlobMember(value));
        }

        public Builder setString(String value) {
            return this.setValue(new StringMember(value));
        }

        public Builder setTimestamp(Instant value) {
            return this.setValue(new TimestampMember(value));
        }

        public Builder setTimestamp(String value) {
            return this.setValue(new TimestampMember(value));
        }

        public Builder setTimestamp(long value) {
            return this.setValue(new TimestampMember(value));
        }

        private Builder setValue(EventHeaderValue<?> value) {
            if (this.value != null) {
                throw new IllegalArgumentException("Only one value may be set for unions.");
            }
            this.value = value;
            return this;
        }
    }

    public static final class TimestampMember
    extends EventHeaderValue<Instant> {
        public TimestampMember(Instant value) {
            super(Type.TIMESTAMP, value);
        }

        public TimestampMember(String value) {
            super(Type.TIMESTAMP, Instant.from(DateTimeFormatter.ISO_INSTANT.parse(value)));
        }

        public TimestampMember(long value) {
            super(Type.TIMESTAMP, Instant.ofEpochSecond(value));
        }

        @Override
        public Instant asTimestamp() {
            return (Instant)this.value;
        }

        @Override
        public String asString() {
            return DateTimeFormatter.ISO_INSTANT.format((TemporalAccessor)this.value);
        }

        public Node toNode() {
            return Node.objectNodeBuilder().withMember(this.getType().name().toLowerCase(Locale.ENGLISH), (ToNode)Node.from((String)this.asString())).build();
        }
    }

    public static final class StringMember
    extends EventHeaderValue<String> {
        public StringMember(String value) {
            super(Type.STRING, value);
        }

        @Override
        public String asString() {
            return (String)this.value;
        }

        public Node toNode() {
            return Node.objectNodeBuilder().withMember(this.getType().name().toLowerCase(Locale.ENGLISH), (ToNode)Node.from((String)((String)this.value))).build();
        }
    }

    public static final class BlobMember
    extends EventHeaderValue<byte[]> {
        public BlobMember(byte[] value) {
            super(Type.BLOB, value);
        }

        public BlobMember(String value) {
            super(Type.BLOB, value.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public byte[] asBlob() {
            return (byte[])this.value;
        }

        @Override
        public String asString() {
            return Base64.getEncoder().encodeToString((byte[])this.value);
        }

        public Node toNode() {
            return Node.objectNodeBuilder().withMember(this.getType().name().toLowerCase(Locale.ENGLISH), (ToNode)Node.from((String)this.asString())).build();
        }
    }

    public static final class LongMember
    extends EventHeaderValue<Long> {
        public LongMember(long value) {
            super(Type.LONG, value);
        }

        @Override
        public long asLong() {
            return (Long)this.value;
        }

        public Node toNode() {
            return Node.objectNodeBuilder().withMember(this.getType().name().toLowerCase(Locale.ENGLISH), (ToNode)Node.from((Number)((Number)this.value))).build();
        }
    }

    public static final class IntegerMember
    extends EventHeaderValue<Integer> {
        public IntegerMember(int value) {
            super(Type.INTEGER, value);
        }

        @Override
        public int asInteger() {
            return (Integer)this.value;
        }

        public Node toNode() {
            return Node.objectNodeBuilder().withMember(this.getType().name().toLowerCase(Locale.ENGLISH), (ToNode)Node.from((Number)((Number)this.value))).build();
        }
    }

    public static final class ShortMember
    extends EventHeaderValue<Short> {
        public ShortMember(short value) {
            super(Type.SHORT, value);
        }

        @Override
        public short asShort() {
            return (Short)this.value;
        }

        public Node toNode() {
            return Node.objectNodeBuilder().withMember(this.getType().name().toLowerCase(Locale.ENGLISH), (ToNode)Node.from((Number)((Number)this.value))).build();
        }
    }

    public static final class ByteMember
    extends EventHeaderValue<Byte> {
        public ByteMember(byte value) {
            super(Type.BYTE, value);
        }

        @Override
        public byte asByte() {
            return (Byte)this.value;
        }

        public Node toNode() {
            return Node.objectNodeBuilder().withMember(this.getType().name().toLowerCase(Locale.ENGLISH), (ToNode)Node.from((Number)((Number)this.value))).build();
        }
    }

    public static final class BooleanMember
    extends EventHeaderValue<Boolean> {
        public BooleanMember(boolean value) {
            super(Type.BOOLEAN, value);
        }

        @Override
        public boolean asBoolean() {
            return (Boolean)this.value;
        }

        public Node toNode() {
            return Node.objectNodeBuilder().withMember(this.getType().name().toLowerCase(Locale.ENGLISH), (ToNode)Node.from((boolean)((Boolean)this.value))).build();
        }
    }
}

