/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;

public final class TestFailureExpectation
implements ToNode {
    private static final String ERROR_ID = "errorId";
    private final ShapeId errorId;

    private TestFailureExpectation(ShapeId errorId) {
        this.errorId = errorId;
    }

    public static TestFailureExpectation anyError() {
        return new TestFailureExpectation(null);
    }

    public static TestFailureExpectation errorWithId(ShapeId errorId) {
        return new TestFailureExpectation(errorId);
    }

    public Optional<ShapeId> getErrorId() {
        return Optional.ofNullable(this.errorId);
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withOptionalMember(ERROR_ID, this.getErrorId().map(ShapeId::toString).map(Node::from)).build();
    }

    public static TestFailureExpectation fromNode(Node node) {
        ObjectNode o = node.expectObjectNode();
        return o.getStringMember(ERROR_ID).map(ShapeId::fromNode).map(TestFailureExpectation::errorWithId).orElse(TestFailureExpectation.anyError());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.toNode().equals(((TestFailureExpectation)o).toNode());
    }

    public int hashCode() {
        return this.toNode().hashCode();
    }
}

