/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.node.TimestampValidationStrategy;
import software.amazon.smithy.protocoltests.traits.HttpMessageTestCase;
import software.amazon.smithy.protocoltests.traits.ProtocolTestValidationUtils;
import software.amazon.smithy.utils.ListUtils;

abstract class ProtocolTestCaseValidator<T extends Trait>
extends AbstractValidator {
    private final Class<T> traitClass;
    private final ShapeId traitId;
    private final String descriptor;

    ProtocolTestCaseValidator(ShapeId traitId, Class<T> traitClass, String descriptor) {
        this.traitId = traitId;
        this.traitClass = traitClass;
        this.descriptor = descriptor;
    }

    public List<ValidationEvent> validate(Model model) {
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(this.traitClass)) {
            events.addAll(this.validateShape(model, operationIndex, shape, shape.expectTrait(this.traitClass)));
        }
        return events;
    }

    abstract StructureShape getStructure(Shape var1, OperationIndex var2);

    abstract List<? extends HttpMessageTestCase> getTestCases(T var1);

    boolean isValidatedBy(Shape shape) {
        return shape instanceof OperationShape;
    }

    private List<ValidationEvent> validateShape(Model model, OperationIndex operationIndex, Shape shape, T trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        List<HttpMessageTestCase> testCases = this.getTestCases(trait);
        for (int i = 0; i < testCases.size(); ++i) {
            StructureShape struct;
            HttpMessageTestCase testCase = testCases.get(i);
            events.addAll(this.validateMediaType(shape, (Trait)trait, testCase));
            Optional<ShapeId> vendorParamsShapeOptional = testCase.getVendorParamsShape();
            ObjectNode vendorParams = testCase.getVendorParams();
            if (vendorParamsShapeOptional.isPresent() && this.isValidatedBy(shape)) {
                if (vendorParams.isEmpty()) {
                    events.add(this.warning(shape, (FromSourceLocation)trait, "Protocol test case defined a `vendorParamsShape` but no `vendorParams`"));
                } else {
                    Shape vendorParamsShape = model.expectShape(vendorParamsShapeOptional.get());
                    NodeValidationVisitor vendorParamsValidator = this.createVisitor(vendorParams, model, shape, i, ".vendorParams");
                    events.addAll((Collection)vendorParamsShape.accept((ShapeVisitor)vendorParamsValidator));
                }
            }
            if ((struct = this.getStructure(shape, operationIndex)) != null) {
                NodeValidationVisitor validator = this.createVisitor(testCase.getParams(), model, shape, i, ".params");
                events.addAll((Collection)struct.accept((ShapeVisitor)validator));
                continue;
            }
            if (testCase.getParams().isEmpty() || !this.isValidatedBy(shape)) continue;
            events.add(this.error(shape, (FromSourceLocation)trait, String.format("Protocol test %s parameters provided for operation with no %s: `%s`", this.descriptor, this.descriptor, Node.printJson((Node)testCase.getParams()))));
        }
        return events;
    }

    private NodeValidationVisitor createVisitor(ObjectNode value, Model model, Shape shape, int position, String contextSuffix) {
        return NodeValidationVisitor.builder().model(model).eventShapeId(shape.getId()).value((Node)value).startingContext(this.traitId + "." + position + contextSuffix).eventId(this.getName()).timestampValidationStrategy(TimestampValidationStrategy.EPOCH_SECONDS).addFeature(NodeValidationVisitor.Feature.ALLOW_OPTIONAL_NULLS).build();
    }

    private List<ValidationEvent> validateMediaType(Shape shape, Trait trait, HttpMessageTestCase test) {
        if (!test.getBodyMediaType().isPresent()) {
            return Collections.emptyList();
        }
        return ProtocolTestValidationUtils.validateMediaType(test.getBody().orElse(""), test.getBodyMediaType().get()).map(e -> ListUtils.of((Object)this.emitMediaTypeError(shape, trait, test, (Throwable)e))).orElse(Collections.emptyList());
    }

    private ValidationEvent emitMediaTypeError(Shape shape, Trait trait, HttpMessageTestCase test, Throwable e) {
        return this.danger(shape, (FromSourceLocation)trait, String.format("Invalid %s content in `%s` protocol test case `%s`: %s", test.getBodyMediaType().orElse(""), trait.toShapeId(), test.getId(), e.getMessage()));
    }
}

