/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.protocoltests.traits.HttpMalformedRequestTestCase;
import software.amazon.smithy.protocoltests.traits.HttpMalformedRequestTestsTrait;
import software.amazon.smithy.protocoltests.traits.HttpMessageTestCase;
import software.amazon.smithy.protocoltests.traits.HttpRequestTestsTrait;
import software.amazon.smithy.protocoltests.traits.HttpResponseTestsTrait;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class UniqueProtocolTestCaseIdValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        TreeMap<String, List<Shape>> requestIdsToTraits = new TreeMap<String, List<Shape>>();
        TreeMap<String, List<Shape>> responseIdsToTraits = new TreeMap<String, List<Shape>>();
        TreeMap<String, List<Shape>> malformedRequestIdsToTraits = new TreeMap<String, List<Shape>>();
        Stream.concat(model.shapes(OperationShape.class), model.shapes(StructureShape.class)).forEach(shape -> {
            shape.getTrait(HttpRequestTestsTrait.class).ifPresent(trait -> this.addTestCaseIdsToMap((Shape)shape, (List<? extends HttpMessageTestCase>)trait.getTestCases(), (Map<String, List<Shape>>)requestIdsToTraits));
            shape.getTrait(HttpResponseTestsTrait.class).ifPresent(trait -> this.addTestCaseIdsToMap((Shape)shape, (List<? extends HttpMessageTestCase>)trait.getTestCases(), (Map<String, List<Shape>>)responseIdsToTraits));
            shape.getTrait(HttpMalformedRequestTestsTrait.class).ifPresent(t -> this.addMalformedRequestTestCaseIdsToMap((Shape)shape, t.getTestCases(), (Map<String, List<Shape>>)responseIdsToTraits));
        });
        this.removeEntriesWithSingleValue(requestIdsToTraits);
        this.removeEntriesWithSingleValue(responseIdsToTraits);
        this.removeEntriesWithSingleValue(malformedRequestIdsToTraits);
        return this.collectEvents(requestIdsToTraits, responseIdsToTraits, malformedRequestIdsToTraits);
    }

    private void addTestCaseIdsToMap(Shape shape, List<? extends HttpMessageTestCase> testCases, Map<String, List<Shape>> map) {
        for (HttpMessageTestCase httpMessageTestCase : testCases) {
            map.computeIfAbsent(httpMessageTestCase.getId(), id -> new ArrayList()).add(shape);
        }
    }

    private void addMalformedRequestTestCaseIdsToMap(Shape shape, List<HttpMalformedRequestTestCase> testCases, Map<String, List<Shape>> map) {
        for (HttpMalformedRequestTestCase testCase : testCases) {
            map.computeIfAbsent(testCase.getId(), id -> new ArrayList()).add(shape);
        }
    }

    private void removeEntriesWithSingleValue(Map<String, List<Shape>> map) {
        map.keySet().removeIf(key -> ((List)map.get(key)).size() == 1);
    }

    private List<ValidationEvent> collectEvents(Map<String, List<Shape>> requestIdsToTraits, Map<String, List<Shape>> responseIdsToTraits, Map<String, List<Shape>> malformedRequestIdsToTraits) {
        if (requestIdsToTraits.isEmpty() && responseIdsToTraits.isEmpty() && malformedRequestIdsToTraits.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ValidationEvent> mutableEvents = new ArrayList<ValidationEvent>();
        this.addValidationEvents(requestIdsToTraits, mutableEvents, HttpRequestTestsTrait.ID);
        this.addValidationEvents(responseIdsToTraits, mutableEvents, HttpResponseTestsTrait.ID);
        this.addValidationEvents(malformedRequestIdsToTraits, mutableEvents, HttpMalformedRequestTestsTrait.ID);
        return mutableEvents;
    }

    private void addValidationEvents(Map<String, List<Shape>> conflicts, List<ValidationEvent> mutableEvents, ShapeId trait) {
        for (Map.Entry<String, List<Shape>> entry : conflicts.entrySet()) {
            for (Shape shape : entry.getValue()) {
                mutableEvents.add(this.error(shape, String.format("Conflicting `%s` test case IDs found for ID `%s`: %s", trait, entry.getKey(), ValidationUtils.tickedList(entry.getValue().stream().map(Shape::getId)))));
            }
        }
    }
}

