/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.Collection;
import java.util.List;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.protocoltests.traits.HttpMalformedRequestTestCase;
import software.amazon.smithy.protocoltests.traits.ParameterizedHttpMalformedRequestTestCase;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class HttpMalformedRequestTestsTrait
extends AbstractTrait {
    public static final ShapeId ID = ShapeId.from((String)"smithy.test#httpMalformedRequestTests");
    private final List<ParameterizedHttpMalformedRequestTestCase> testCases;

    public HttpMalformedRequestTestsTrait(List<ParameterizedHttpMalformedRequestTestCase> testCases) {
        this(SourceLocation.NONE, testCases);
    }

    public HttpMalformedRequestTestsTrait(SourceLocation sourceLocation, List<ParameterizedHttpMalformedRequestTestCase> testCases) {
        super(ID, (FromSourceLocation)sourceLocation);
        this.testCases = ListUtils.copyOf(testCases);
    }

    public List<HttpMalformedRequestTestCase> getTestCases() {
        return (List)this.testCases.stream().map(ParameterizedHttpMalformedRequestTestCase::generateTestCasesFromParameters).flatMap(Collection::stream).collect(ListUtils.toUnmodifiableList());
    }

    List<ParameterizedHttpMalformedRequestTestCase> getParameterizedTestCases() {
        return this.testCases;
    }

    protected Node createNode() {
        return (Node)this.getParameterizedTestCases().stream().collect(ArrayNode.collect((SourceLocation)this.getSourceLocation()));
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ArrayNode values = value.expectArrayNode();
            List testCases = values.getElementsAs(ParameterizedHttpMalformedRequestTestCase::fromNode);
            HttpMalformedRequestTestsTrait result = new HttpMalformedRequestTestsTrait(value.getSourceLocation(), testCases);
            result.setNodeCache(value);
            return result;
        }
    }
}

