/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.protocoltests.traits.HttpMessageTestCase;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class HttpResponseTestCase
extends HttpMessageTestCase
implements ToSmithyBuilder<HttpResponseTestCase> {
    private static final String CODE = "code";
    private final int code;

    private HttpResponseTestCase(Builder builder) {
        super(builder);
        this.code = (Integer)SmithyBuilder.requiredState((String)CODE, (Object)builder.code);
    }

    public int getCode() {
        return this.code;
    }

    static HttpResponseTestCase fromNode(Node node) {
        Builder builder = HttpResponseTestCase.builder();
        ObjectNode o = node.expectObjectNode();
        builder.code(o.expectNumberMember(CODE).getValue().intValue());
        HttpResponseTestCase.updateBuilderFromNode(builder, node);
        return builder.build();
    }

    @Override
    public Node toNode() {
        return super.toNode().expectObjectNode().withMember(CODE, (Number)this.getCode());
    }

    public Builder toBuilder() {
        Builder builder = HttpResponseTestCase.builder().code(this.getCode());
        this.updateBuilder(builder);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends HttpMessageTestCase.Builder<Builder, HttpResponseTestCase> {
        private Integer code;

        private Builder() {
        }

        public Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public HttpResponseTestCase build() {
            return new HttpResponseTestCase(this);
        }
    }
}

