/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.List;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.protocoltests.traits.HttpResponseTestCase;
import software.amazon.smithy.utils.ListUtils;

public final class HttpResponseTestsTrait
extends AbstractTrait {
    public static final ShapeId ID = ShapeId.from((String)"smithy.test#httpResponseTests");
    private final List<HttpResponseTestCase> testCases;

    public HttpResponseTestsTrait(List<HttpResponseTestCase> testCases) {
        this(SourceLocation.NONE, testCases);
    }

    public HttpResponseTestsTrait(SourceLocation sourceLocation, List<HttpResponseTestCase> testCases) {
        super(ID, (FromSourceLocation)sourceLocation);
        this.testCases = ListUtils.copyOf(testCases);
    }

    public List<HttpResponseTestCase> getTestCases() {
        return this.testCases;
    }

    protected Node createNode() {
        return (Node)this.getTestCases().stream().collect(ArrayNode.collect());
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ArrayNode values = value.expectArrayNode();
            List testCases = values.getElementsAs(HttpResponseTestCase::fromNode);
            return new HttpResponseTestsTrait(value.getSourceLocation(), testCases);
        }
    }
}

