/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.TreeMap;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.CallbackObject;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.LinkObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.openapi.model.SecurityScheme;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ComponentsObject
extends Component
implements ToSmithyBuilder<ComponentsObject> {
    private final Map<String, Schema> schemas = new TreeMap<String, Schema>();
    private final Map<String, ResponseObject> responses = new TreeMap<String, ResponseObject>();
    private final Map<String, ParameterObject> parameters = new TreeMap<String, ParameterObject>();
    private final Map<String, RequestBodyObject> requestBodies = new TreeMap<String, RequestBodyObject>();
    private final Map<String, ParameterObject> headers = new TreeMap<String, ParameterObject>();
    private final Map<String, SecurityScheme> securitySchemes = new TreeMap<String, SecurityScheme>();
    private final Map<String, LinkObject> links = new TreeMap<String, LinkObject>();
    private final Map<String, CallbackObject> callbacks = new TreeMap<String, CallbackObject>();

    private ComponentsObject(Builder builder) {
        super(builder);
        this.schemas.putAll(builder.schemas);
        this.responses.putAll(builder.responses);
        this.parameters.putAll(builder.parameters);
        this.requestBodies.putAll(builder.requestBodies);
        this.headers.putAll(builder.headers);
        this.securitySchemes.putAll(builder.securitySchemes);
        this.links.putAll(builder.links);
        this.callbacks.putAll(builder.callbacks);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    public Map<String, ResponseObject> getResponses() {
        return this.responses;
    }

    public Map<String, ParameterObject> getParameters() {
        return this.parameters;
    }

    public Map<String, RequestBodyObject> getRequestBodies() {
        return this.requestBodies;
    }

    public Map<String, ParameterObject> getHeaders() {
        return this.headers;
    }

    public Map<String, SecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public Map<String, LinkObject> getLinks() {
        return this.links;
    }

    public Map<String, CallbackObject> getCallbacks() {
        return this.callbacks;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        if (!this.schemas.isEmpty()) {
            builder.withMember("schemas", (ToNode)this.schemas.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (!this.responses.isEmpty()) {
            builder.withMember("responses", (ToNode)this.responses.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (!this.parameters.isEmpty()) {
            builder.withMember("parameters", (ToNode)this.parameters.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (!this.requestBodies.isEmpty()) {
            builder.withMember("requestBodies", (ToNode)this.requestBodies.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (!this.headers.isEmpty()) {
            builder.withMember("headers", (ToNode)this.headers.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (!this.securitySchemes.isEmpty()) {
            builder.withMember("securitySchemes", (ToNode)this.securitySchemes.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (!this.links.isEmpty()) {
            builder.withMember("links", (ToNode)this.links.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (!this.callbacks.isEmpty()) {
            builder.withMember("callbacks", (ToNode)this.callbacks.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return builder;
    }

    public Builder toBuilder() {
        return (Builder)ComponentsObject.builder().schemas(this.schemas).responses(this.responses).parameters(this.parameters).requestBodies(this.requestBodies).headers(this.headers).securitySchemes(this.securitySchemes).links(this.links).callbacks(this.callbacks).extensions(this.getExtensions());
    }

    public static final class Builder
    extends Component.Builder<Builder, ComponentsObject> {
        private final Map<String, Schema> schemas = new TreeMap<String, Schema>();
        private final Map<String, ResponseObject> responses = new TreeMap<String, ResponseObject>();
        private final Map<String, ParameterObject> parameters = new TreeMap<String, ParameterObject>();
        private final Map<String, RequestBodyObject> requestBodies = new TreeMap<String, RequestBodyObject>();
        private final Map<String, ParameterObject> headers = new TreeMap<String, ParameterObject>();
        private final Map<String, SecurityScheme> securitySchemes = new TreeMap<String, SecurityScheme>();
        private final Map<String, LinkObject> links = new TreeMap<String, LinkObject>();
        private final Map<String, CallbackObject> callbacks = new TreeMap<String, CallbackObject>();

        private Builder() {
        }

        public ComponentsObject build() {
            return new ComponentsObject(this);
        }

        public Builder schemas(Map<String, Schema> schemas) {
            this.schemas.clear();
            this.schemas.putAll(schemas);
            return this;
        }

        public Builder putSchema(String name, Schema schema) {
            this.schemas.put(name, schema);
            return this;
        }

        public Builder removeSchema(String name) {
            this.schemas.remove(name);
            return this;
        }

        public Builder responses(Map<String, ResponseObject> responses) {
            this.responses.clear();
            this.responses.putAll(responses);
            return this;
        }

        public Builder putResponse(String name, ResponseObject response) {
            this.responses.put(name, response);
            return this;
        }

        public Builder parameters(Map<String, ParameterObject> parameters) {
            this.parameters.clear();
            this.parameters.putAll(parameters);
            return this;
        }

        public Builder putParameter(String name, ParameterObject parameter) {
            this.parameters.put(name, parameter);
            return this;
        }

        public Builder requestBodies(Map<String, RequestBodyObject> requestBodies) {
            this.requestBodies.clear();
            this.requestBodies.putAll(requestBodies);
            return this;
        }

        public Builder putRequestBodies(String name, RequestBodyObject requestBody) {
            this.requestBodies.put(name, requestBody);
            return this;
        }

        public Builder headers(Map<String, ParameterObject> headers) {
            this.headers.clear();
            this.headers.putAll(headers);
            return this;
        }

        public Builder putHeader(String name, ParameterObject header) {
            this.headers.put(name, header);
            return this;
        }

        public Builder securitySchemes(Map<String, SecurityScheme> securitySchemes) {
            this.securitySchemes.clear();
            this.securitySchemes.putAll(securitySchemes);
            return this;
        }

        public Builder putSecurityScheme(String name, SecurityScheme securityScheme) {
            this.securitySchemes.put(name, securityScheme);
            return this;
        }

        public Builder removeSecurityScheme(String name) {
            this.securitySchemes.remove(name);
            return this;
        }

        public Builder links(Map<String, LinkObject> links) {
            this.links.clear();
            this.links.putAll(links);
            return this;
        }

        public Builder putLink(String name, LinkObject link) {
            this.links.put(name, link);
            return this;
        }

        public Builder callbacks(Map<String, CallbackObject> callbacks) {
            this.callbacks.clear();
            this.callbacks.putAll(callbacks);
            return this;
        }

        public Builder putCallbacks(String name, CallbackObject callback) {
            this.callbacks.put(name, callback);
            return this;
        }
    }
}

