/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.ExampleObject;
import software.amazon.smithy.openapi.model.MediaTypeObject;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ParameterObject
extends Component
implements ToSmithyBuilder<ParameterObject> {
    private final String name;
    private final String in;
    private final String description;
    private final boolean required;
    private final boolean deprecated;
    private final boolean allowEmptyValue;
    private final String style;
    private final boolean explode;
    private final boolean allowReserved;
    private final Schema schema;
    private final ExampleObject example;
    private final Map<String, ExampleObject> examples;
    private final Map<String, MediaTypeObject> content;

    private ParameterObject(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.in = builder.in;
        this.description = builder.description;
        this.required = builder.required;
        this.deprecated = builder.deprecated;
        this.allowEmptyValue = builder.allowEmptyValue;
        this.style = builder.style;
        this.explode = builder.explode;
        this.allowReserved = builder.allowReserved;
        this.schema = builder.schema;
        this.example = builder.example;
        this.examples = (Map)builder.examples.copy();
        this.content = (Map)builder.content.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getIn() {
        return Optional.ofNullable(this.in);
    }

    public Map<String, ExampleObject> getExamples() {
        return this.examples;
    }

    public Map<String, MediaTypeObject> getContent() {
        return this.content;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public boolean isExplode() {
        return this.explode;
    }

    public boolean isAllowReserved() {
        return this.allowReserved;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getStyle() {
        return Optional.ofNullable(this.style);
    }

    public Optional<Schema> getSchema() {
        return Optional.ofNullable(this.schema);
    }

    public Optional<ExampleObject> getExample() {
        return Optional.ofNullable(this.example);
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember("name", this.getName().map(Node::from)).withOptionalMember("in", this.getIn().map(Node::from)).withOptionalMember("description", this.getDescription().map(Node::from)).withOptionalMember("style", this.getStyle().map(Node::from)).withOptionalMember("schema", this.getSchema()).withOptionalMember("example", this.getExample());
        if (this.isDeprecated()) {
            builder.withMember("deprecated", (ToNode)Node.from((boolean)true));
        }
        if (this.isAllowEmptyValue()) {
            builder.withMember("allowEmptyValue", (ToNode)Node.from((boolean)true));
        }
        if (this.isAllowReserved()) {
            builder.withMember("allowReserved", (ToNode)Node.from((boolean)true));
        }
        if (this.isExplode()) {
            builder.withMember("explode", (ToNode)Node.from((boolean)true));
        }
        if (this.isRequired()) {
            builder.withMember("required", (ToNode)Node.from((boolean)true));
        }
        if (!this.examples.isEmpty()) {
            builder.withMember("examples", (ToNode)((ObjectNode)this.getExamples().entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.content.isEmpty()) {
            builder.withMember("content", (ToNode)((ObjectNode)this.getContent().entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        return builder;
    }

    public Builder toBuilder() {
        Builder builder = ((Builder)ParameterObject.builder().extensions(this.getExtensions())).name(this.name).in(this.in).description(this.description).required(this.required).deprecated(this.deprecated).allowEmptyValue(this.allowEmptyValue).style(this.style).explode(this.explode).allowReserved(this.allowReserved).schema(this.schema).example(this.example == null ? null : this.example.toNode()).content(this.content);
        for (Map.Entry<String, ExampleObject> ex : this.examples.entrySet()) {
            builder.putExample(ex.getKey(), ex.getValue().toNode());
        }
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder, ParameterObject> {
        private String name;
        private String in;
        private String description;
        private boolean required;
        private boolean deprecated;
        private boolean allowEmptyValue;
        private String style;
        private boolean explode;
        private boolean allowReserved;
        private Schema schema;
        private ExampleObject example;
        private final BuilderRef<Map<String, ExampleObject>> examples = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, MediaTypeObject>> content = BuilderRef.forSortedMap();

        private Builder() {
        }

        public ParameterObject build() {
            return new ParameterObject(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder in(String in) {
            this.in = in;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder allowEmptyValue(boolean allowEmptyValue) {
            this.allowEmptyValue = allowEmptyValue;
            return this;
        }

        public Builder style(String style) {
            this.style = style;
            return this;
        }

        public Builder explode(boolean explode) {
            this.explode = explode;
            return this;
        }

        public Builder allowReserved(boolean allowReserved) {
            this.allowReserved = allowReserved;
            return this;
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder example(Node example) {
            this.example = ExampleObject.fromNode(example);
            return this;
        }

        public Builder examples(Map<String, Node> examples) {
            this.examples.clear();
            for (Map.Entry<String, Node> example : examples.entrySet()) {
                ((Map)this.examples.get()).put(example.getKey(), ExampleObject.fromNode(example.getValue()));
            }
            return this;
        }

        public Builder putExample(String name, Node example) {
            ((Map)this.examples.get()).put(name, ExampleObject.fromNode(example));
            return this;
        }

        public Builder content(Map<String, MediaTypeObject> content) {
            this.content.clear();
            content.forEach(this::putContent);
            return this;
        }

        public Builder putContent(String name, MediaTypeObject mediaTypeObject) {
            ((Map)this.content.get()).put(name, mediaTypeObject);
            return this;
        }
    }
}

