/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.mappers;

import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.fromsmithy.mappers.CheckForGreedyLabels;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class CheckForPrefixHeaders
implements OpenApiMapper {
    private static final Logger LOGGER = Logger.getLogger(CheckForGreedyLabels.class.getName());

    @Override
    public byte getOrder() {
        return -128;
    }

    @Override
    public void before(Context<? extends Trait> context, OpenApi.Builder builder) {
        HttpBindingIndex httpBindings = HttpBindingIndex.of((Model)context.getModel());
        context.getModel().shapes(OperationShape.class).forEach(operation -> {
            this.check(context, httpBindings.getRequestBindings((ToShapeId)operation, HttpBinding.Location.PREFIX_HEADERS));
            this.checkForResponseHeaders(context, httpBindings, (ToShapeId)operation);
            operation.getErrorsSet().forEach(error -> this.checkForResponseHeaders(context, httpBindings, (ToShapeId)error));
        });
    }

    private void checkForResponseHeaders(Context<? extends Trait> context, HttpBindingIndex bindingIndex, ToShapeId shapeId) {
        this.check(context, bindingIndex.getResponseBindings(shapeId, HttpBinding.Location.PREFIX_HEADERS));
    }

    private void check(Context<? extends Trait> context, List<HttpBinding> bindings) {
        OpenApiConfig.HttpPrefixHeadersStrategy strategy = context.getConfig().getOnHttpPrefixHeaders();
        for (HttpBinding binding : bindings) {
            switch (strategy) {
                case WARN: {
                    LOGGER.warning(CheckForPrefixHeaders.createMessage(binding));
                    break;
                }
                case FAIL: {
                    throw new OpenApiException(CheckForPrefixHeaders.createMessage(binding));
                }
            }
        }
    }

    private static String createMessage(HttpBinding binding) {
        MemberShape member = binding.getMember();
        return String.format("The `httpPrefixHeaders` trait is not supported by OpenAPI and was found on `%s`", member.getId());
    }
}

