/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi;

import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.openapi.traits.SpecificationExtensionTrait;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class OpenApiUtils {
    private OpenApiUtils() {
    }

    public static String getSpecificationExtensionName(ShapeId metaTraitId, SpecificationExtensionTrait specificationExtensionTrait) {
        return specificationExtensionTrait.getAs().orElse("x-" + metaTraitId.toString().replaceAll("[.#]", "-"));
    }

    public static Map<String, Node> getSpecificationExtensionsMap(Model model, Shape shape) {
        LinkedHashMap<String, Node> specificationExtensions = new LinkedHashMap<String, Node>();
        shape.getAllTraits().forEach((traitId, trait) -> model.getShape(traitId).flatMap(traitShape -> traitShape.getTrait(SpecificationExtensionTrait.class)).map(specificationExtension -> OpenApiUtils.getSpecificationExtensionName(traitId, specificationExtension)).ifPresent(name -> specificationExtensions.put((String)name, trait.toNode())));
        return specificationExtensions;
    }
}

