/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.protocols;

import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.protocols.ModelUtils;

final class QuerySchemaVisitor<T extends Trait>
extends ShapeVisitor.Default<Schema> {
    private final Context<T> context;
    private final Schema schema;
    private final MemberShape member;

    QuerySchemaVisitor(Context<T> context, Schema schema, MemberShape member) {
        this.context = context;
        this.schema = schema;
        this.member = member;
    }

    protected Schema getDefault(Shape shape) {
        return this.schema;
    }

    public Schema listShape(ListShape shape) {
        MemberShape collectionMember = shape.getMember();
        Shape collectionTarget = this.context.getModel().expectShape(collectionMember.getTarget());
        Schema refSchema = this.context.inlineOrReferenceSchema(collectionMember);
        Schema itemsSchema = (Schema)collectionTarget.accept(new QuerySchemaVisitor<T>(this.context, refSchema, collectionMember));
        return this.schema.toBuilder().ref(null).type("array").items(itemsSchema).build();
    }

    public Schema timestampShape(TimestampShape shape) {
        if (this.member.hasTrait(TimestampFormatTrait.ID)) {
            return this.schema;
        }
        Schema originalSchema = this.context.getJsonSchemaConverter().convertShape((Shape)this.member).getRootSchema();
        return ModelUtils.convertSchemaToStringBuilder(originalSchema).format("date-time").build();
    }
}

