/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Comparator;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.ExternalDocumentation;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TagObject
extends Component
implements ToSmithyBuilder<TagObject>,
Comparable<TagObject> {
    private static final Comparator<String> STRING_COMPARATOR = Comparator.nullsFirst(String::compareToIgnoreCase);
    private static final Comparator<ExternalDocumentation> EXTERNAL_DOCUMENTATION_COMPARATOR = Comparator.nullsFirst(ExternalDocumentation::compareTo);
    private final String name;
    private final String description;
    private final ExternalDocumentation externalDocs;

    private TagObject(Builder builder) {
        super(builder);
        this.name = (String)SmithyBuilder.requiredState((String)"name", (Object)builder.name);
        this.description = builder.description;
        this.externalDocs = builder.externalDocs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public Optional<ExternalDocumentation> getExternalDocs() {
        return Optional.ofNullable(this.externalDocs);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Builder toBuilder() {
        return ((Builder)TagObject.builder().extensions(this.getExtensions())).name(this.name).description(this.description).externalDocs(this.externalDocs);
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        return Node.objectNodeBuilder().withMember("name", (ToNode)Node.from((String)this.getName())).withOptionalMember("description", this.getDescription().map(Node::from)).withOptionalMember("externalDocs", this.getExternalDocs().map(Component::toNode));
    }

    @Override
    public int compareTo(TagObject that) {
        return Comparator.comparing(TagObject::getName, STRING_COMPARATOR).thenComparing(to -> to.description, STRING_COMPARATOR).thenComparing(to -> to.externalDocs, EXTERNAL_DOCUMENTATION_COMPARATOR).compare(this, that);
    }

    public static final class Builder
    extends Component.Builder<Builder, TagObject> {
        private String name;
        private String description;
        private ExternalDocumentation externalDocs;

        private Builder() {
        }

        public TagObject build() {
            return new TagObject(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder externalDocs(ExternalDocumentation externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }
    }
}

