/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.jsonschema.JsonSchemaVersion;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.OpenApiVersion;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.StringUtils;

public class OpenApiConfig
extends JsonSchemaConfig {
    private static final String SCHEMA_COMPONENTS_POINTER = "#/components/schemas";
    private static final Logger LOGGER = Logger.getLogger(OpenApiConfig.class.getName());
    private static final Map<String, String> DEPRECATED_PROPERTY_RENAMES = new HashMap<String, String>();
    private ShapeId protocol;
    private boolean tags;
    private List<String> supportedTags;
    private String defaultBlobFormat = "byte";
    private boolean keepUnusedComponents;
    private String jsonContentType = "application/json";
    private boolean forbidGreedyLabels;
    private boolean removeGreedyParameterSuffix;
    private HttpPrefixHeadersStrategy onHttpPrefixHeaders = HttpPrefixHeadersStrategy.FAIL;
    private boolean ignoreUnsupportedTraits;
    private Map<String, Node> substitutions = Collections.emptyMap();
    private Map<String, Node> jsonAdd = Collections.emptyMap();
    private List<String> externalDocs = ListUtils.of((Object[])new String[]{"Homepage", "API Reference", "User Guide", "Developer Guide", "Reference", "Guide"});
    private boolean disableIntegerFormat = false;
    private ErrorStatusConflictHandlingStrategy onErrorStatusConflict;
    private OpenApiVersion version = OpenApiVersion.VERSION_3_0_2;

    public OpenApiConfig() {
        this.setDefinitionPointer(SCHEMA_COMPONENTS_POINTER);
        super.setJsonSchemaVersion(this.version.getJsonSchemaVersion());
    }

    public ShapeId getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ShapeId protocol) {
        this.protocol = protocol;
    }

    public String getDefaultBlobFormat() {
        return this.defaultBlobFormat;
    }

    public void setDefaultBlobFormat(String defaultBlobFormat) {
        this.defaultBlobFormat = Objects.requireNonNull(defaultBlobFormat);
    }

    public boolean getTags() {
        return this.tags;
    }

    public void setTags(boolean tags) {
        this.tags = tags;
    }

    public List<String> getSupportedTags() {
        return this.supportedTags;
    }

    public void setSupportedTags(List<String> supportedTags) {
        this.supportedTags = Objects.requireNonNull(supportedTags);
    }

    public boolean getKeepUnusedComponents() {
        return this.keepUnusedComponents;
    }

    public void setKeepUnusedComponents(boolean keepUnusedComponents) {
        this.keepUnusedComponents = keepUnusedComponents;
    }

    public String getJsonContentType() {
        return this.jsonContentType;
    }

    public void setJsonContentType(String jsonContentType) {
        this.jsonContentType = Objects.requireNonNull(jsonContentType);
    }

    public boolean getForbidGreedyLabels() {
        return this.forbidGreedyLabels;
    }

    public void setForbidGreedyLabels(boolean forbidGreedyLabels) {
        this.forbidGreedyLabels = forbidGreedyLabels;
    }

    public boolean getRemoveGreedyParameterSuffix() {
        return this.removeGreedyParameterSuffix;
    }

    public void setRemoveGreedyParameterSuffix(boolean removeGreedyParameterSuffix) {
        this.removeGreedyParameterSuffix = removeGreedyParameterSuffix;
    }

    public HttpPrefixHeadersStrategy getOnHttpPrefixHeaders() {
        return this.onHttpPrefixHeaders;
    }

    public void setOnHttpPrefixHeaders(HttpPrefixHeadersStrategy onHttpPrefixHeaders) {
        this.onHttpPrefixHeaders = Objects.requireNonNull(onHttpPrefixHeaders);
    }

    public boolean getIgnoreUnsupportedTraits() {
        return this.ignoreUnsupportedTraits;
    }

    public void setIgnoreUnsupportedTraits(boolean ignoreUnsupportedTraits) {
        this.ignoreUnsupportedTraits = ignoreUnsupportedTraits;
    }

    public Map<String, Node> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Map<String, Node> substitutions) {
        this.substitutions = Objects.requireNonNull(substitutions);
    }

    public Map<String, Node> getJsonAdd() {
        return this.jsonAdd;
    }

    public void setJsonAdd(Map<String, Node> jsonAdd) {
        this.jsonAdd = Objects.requireNonNull(jsonAdd);
    }

    public List<String> getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(List<String> externalDocs) {
        this.externalDocs = Objects.requireNonNull(externalDocs);
    }

    public OpenApiVersion getVersion() {
        return this.version;
    }

    public void setVersion(OpenApiVersion version) {
        this.version = Objects.requireNonNull(version);
        super.setJsonSchemaVersion(version.getJsonSchemaVersion());
    }

    public boolean getDisableIntegerFormat() {
        return this.disableIntegerFormat;
    }

    public void setDisableIntegerFormat(boolean disableIntegerFormat) {
        this.disableIntegerFormat = disableIntegerFormat;
    }

    public ErrorStatusConflictHandlingStrategy getOnErrorStatusConflict() {
        return this.onErrorStatusConflict;
    }

    public void setOnErrorStatusConflict(ErrorStatusConflictHandlingStrategy onErrorStatusConflict) {
        this.onErrorStatusConflict = Objects.requireNonNull(onErrorStatusConflict);
    }

    public static OpenApiConfig fromNode(Node input) {
        NodeMapper mapper = new NodeMapper();
        mapper.setWhenMissingSetter(NodeMapper.WhenMissing.IGNORE);
        ObjectNode node = OpenApiConfig.fixDeprecatedKeys(input.expectObjectNode());
        OpenApiConfig config = new OpenApiConfig();
        mapper.deserializeInto((Node)node, (Object)config);
        for (Map.Entry entry : node.getStringMap().entrySet()) {
            config.putExtension((String)entry.getKey(), (Node)entry.getValue());
        }
        return config;
    }

    private static ObjectNode fixDeprecatedKeys(ObjectNode node) {
        ObjectNode mapped = node;
        for (Map.Entry entry : mapped.getStringMap().entrySet()) {
            if (DEPRECATED_PROPERTY_RENAMES.containsKey(entry.getKey())) {
                String rename = DEPRECATED_PROPERTY_RENAMES.get(entry.getKey());
                LOGGER.warning("Deprecated `openapi` configuration setting found: " + (String)entry.getKey() + ". Use " + rename + " instead");
                mapped = mapped.withMember(rename, (ToNode)((Node)entry.getValue()));
                mapped = mapped.withoutMember((String)entry.getKey());
                continue;
            }
            if (((String)entry.getKey()).startsWith("disable.")) {
                String property = StringUtils.uncapitalize((String)((String)entry.getKey()).substring(8));
                throw new OpenApiException("Unsupported `openapi` configuration setting found: " + (String)entry.getKey() + ". Add `" + property + "` to the `disableFeatures` property instead");
            }
            if (!((String)entry.getKey()).startsWith("openapi.use.")) continue;
            throw new OpenApiException(String.format("The `%s` `openapi` plugin property is no longer supported. Use the `disableFeatures` property instead to disable features.", entry.getKey()));
        }
        return mapped;
    }

    public void setJsonSchemaVersion(JsonSchemaVersion schemaVersion) {
        throw new OpenApiException("`jsonSchemaVersion` configuration parameter is not supported by OpenAPI plugin.");
    }

    static {
        DEPRECATED_PROPERTY_RENAMES.put("openapi.tags", "tags");
        DEPRECATED_PROPERTY_RENAMES.put("openapi.supportedTags", "supportedTags");
        DEPRECATED_PROPERTY_RENAMES.put("openapi.defaultBlobFormat", "defaultBlobFormat");
        DEPRECATED_PROPERTY_RENAMES.put("openapi.keepUnusedComponents", "keepUnusedComponents");
        DEPRECATED_PROPERTY_RENAMES.put("openapi.aws.jsonContentType", "jsonContentType");
        DEPRECATED_PROPERTY_RENAMES.put("openapi.forbidGreedyLabels", "forbidGreedyLabels");
        DEPRECATED_PROPERTY_RENAMES.put("openapi.onHttpPrefixHeaders", "onHttpPrefixHeaders");
        DEPRECATED_PROPERTY_RENAMES.put("openapi.ignoreUnsupportedTrait", "ignoreUnsupportedTraits");
        DEPRECATED_PROPERTY_RENAMES.put("openapi.ignoreUnsupportedTraits", "ignoreUnsupportedTraits");
        DEPRECATED_PROPERTY_RENAMES.put("openapi.substitutions", "substitutions");
        DEPRECATED_PROPERTY_RENAMES.put("apigateway.disableCloudFormationSubstitution", "disableCloudFormationSubstitution");
    }

    public static enum HttpPrefixHeadersStrategy {
        FAIL,
        WARN;

    }

    public static enum ErrorStatusConflictHandlingStrategy {
        ONE_OF("oneOf");

        private final String stringValue;

        private ErrorStatusConflictHandlingStrategy(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

