/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.SecurityScheme;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;

public interface SecuritySchemeConverter<T extends Trait> {
    public Class<T> getAuthSchemeType();

    default public ShapeId getAuthSchemeId() {
        try {
            Class<T> type = this.getAuthSchemeType();
            return (ShapeId)type.getField("ID").get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to find an ID property on " + this.getAuthSchemeType().getName());
        }
    }

    public SecurityScheme createSecurityScheme(Context<? extends Trait> var1, T var2);

    default public List<String> createSecurityRequirements(Context<? extends Trait> context, T authTrait, Shape shape) {
        return ListUtils.of();
    }

    default public String getOpenApiAuthSchemeName() {
        return this.getAuthSchemeId().toString().replace("#", ".");
    }

    default public Set<String> getAuthRequestHeaders(Context<? extends Trait> context, T authTrait) {
        return SetUtils.of();
    }

    default public Set<String> getAuthResponseHeaders(Context<? extends Trait> context, T authTrait) {
        return SetUtils.of();
    }

    default public boolean usesHttpCredentials() {
        return false;
    }
}

