/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.PathItem;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class CallbackObject
extends Component
implements ToSmithyBuilder<CallbackObject> {
    private final Map<String, PathItem> paths;

    private CallbackObject(Builder builder) {
        super(builder);
        this.paths = Collections.unmodifiableMap(new TreeMap(builder.paths));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, PathItem> getPaths() {
        return this.paths;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        for (Map.Entry<String, PathItem> entry : this.paths.entrySet()) {
            builder.withMember(entry.getKey(), (ToNode)entry.getValue());
        }
        return builder;
    }

    public Builder toBuilder() {
        return ((Builder)CallbackObject.builder().extensions(this.getExtensions())).paths(this.paths);
    }

    public static final class Builder
    extends Component.Builder<Builder, CallbackObject> {
        private Map<String, PathItem> paths = new TreeMap<String, PathItem>();

        private Builder() {
        }

        public CallbackObject build() {
            return new CallbackObject(this);
        }

        public Builder paths(Map<String, PathItem> paths) {
            this.paths.clear();
            this.paths.putAll(paths);
            return this;
        }

        public Builder putPath(String expression, PathItem pathItem) {
            this.paths.put(expression, pathItem);
            return this;
        }
    }
}

