/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.ComponentsObject;
import software.amazon.smithy.openapi.model.ExternalDocumentation;
import software.amazon.smithy.openapi.model.InfoObject;
import software.amazon.smithy.openapi.model.PathItem;
import software.amazon.smithy.openapi.model.ServerObject;
import software.amazon.smithy.openapi.model.TagObject;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class OpenApi
extends Component
implements ToSmithyBuilder<OpenApi> {
    private final String openapi;
    private final InfoObject info;
    private final List<ServerObject> servers;
    private final Map<String, PathItem> paths = new TreeMap<String, PathItem>();
    private final ComponentsObject components;
    private final List<Map<String, List<String>>> security;
    private final List<TagObject> tags;
    private final ExternalDocumentation externalDocs;

    private OpenApi(Builder builder) {
        super(builder);
        this.openapi = (String)SmithyBuilder.requiredState((String)"openapi", (Object)builder.openapi);
        this.info = (InfoObject)SmithyBuilder.requiredState((String)"info", (Object)builder.info);
        this.servers = ListUtils.copyOf((Collection)builder.servers);
        this.paths.putAll(builder.paths);
        this.components = builder.components == null ? ComponentsObject.builder().build() : builder.components;
        this.security = ListUtils.copyOf((Collection)builder.security);
        this.tags = ListUtils.copyOf((Collection)builder.tags);
        this.externalDocs = builder.externalDocs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpenapi() {
        return this.openapi;
    }

    public InfoObject getInfo() {
        return this.info;
    }

    public List<ServerObject> getServers() {
        return this.servers;
    }

    public Map<String, PathItem> getPaths() {
        return this.paths;
    }

    public ComponentsObject getComponents() {
        return this.components;
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public List<TagObject> getTags() {
        return this.tags;
    }

    public Optional<ExternalDocumentation> getExternalDocs() {
        return Optional.ofNullable(this.externalDocs);
    }

    public Builder toBuilder() {
        Builder builder = (Builder)OpenApi.builder().openapi(this.openapi).info(this.info).paths(this.paths).components(this.components).externalDocs(this.externalDocs).extensions(this.getExtensions());
        this.security.forEach(builder::addSecurity);
        this.servers.forEach(builder::addServer);
        this.tags.forEach(builder::addTag);
        return (Builder)builder.extensions(this.getExtensions());
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember("openapi", this.openapi).withMember("info", (ToNode)this.info).withOptionalMember("externalDocumentation", this.getExternalDocs());
        if (!this.servers.isEmpty()) {
            builder.withMember("servers", (ToNode)((ArrayNode)this.servers.stream().collect(ArrayNode.collect())));
        }
        if (!this.paths.isEmpty()) {
            builder.withMember("paths", (ToNode)((ObjectNode)this.paths.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        builder.withMember("components", (ToNode)this.components);
        if (!this.security.isEmpty()) {
            builder.withMember("security", (ToNode)((ArrayNode)this.security.stream().map(mapping -> (ObjectNode)mapping.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(ObjectNode.collectStringKeys(Map.Entry::getKey, entry -> (ToNode)((List)entry.getValue()).stream().map(Node::from).collect(ArrayNode.collect())))).collect(ArrayNode.collect())));
        }
        if (!this.tags.isEmpty()) {
            builder.withMember("tags", (ToNode)((ArrayNode)this.tags.stream().collect(ArrayNode.collect())));
        }
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder, OpenApi> {
        private String openapi;
        private InfoObject info;
        private final List<ServerObject> servers = new ArrayList<ServerObject>();
        private Map<String, PathItem> paths = new TreeMap<String, PathItem>();
        private ComponentsObject components;
        private final Set<Map<String, List<String>>> security = new LinkedHashSet<Map<String, List<String>>>();
        private final List<TagObject> tags = new ArrayList<TagObject>();
        private ExternalDocumentation externalDocs;

        private Builder() {
        }

        public OpenApi build() {
            return new OpenApi(this);
        }

        public Builder openapi(String openapi) {
            this.openapi = openapi;
            return this;
        }

        public Builder info(InfoObject info) {
            this.info = info;
            return this;
        }

        public Builder paths(Map<String, PathItem> paths) {
            this.paths = paths;
            return this;
        }

        public Builder putPath(String path, PathItem item) {
            this.paths.put(path, item);
            return this;
        }

        public Builder removePath(String path) {
            this.paths.remove(path);
            return this;
        }

        public Builder components(ComponentsObject components) {
            this.components = components;
            return this;
        }

        public Builder externalDocs(ExternalDocumentation externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }

        public Builder addServer(ServerObject server) {
            this.servers.add(server);
            return this;
        }

        public Builder clearServer() {
            this.servers.clear();
            return this;
        }

        public Builder addSecurity(Map<String, List<String>> requirement) {
            this.security.add(requirement);
            return this;
        }

        public Builder security(Collection<Map<String, List<String>>> security) {
            this.security.clear();
            this.security.addAll(security);
            return this;
        }

        public Builder clearSecurity() {
            this.security.clear();
            return this;
        }

        public Builder addTag(TagObject tag) {
            this.tags.add(tag);
            return this;
        }

        public Builder clearTags() {
            this.tags.clear();
            return this;
        }
    }
}

