/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.mappers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.model.ComponentsObject;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.PathItem;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class RemoveUnusedComponents
implements OpenApiMapper {
    private static final Logger LOGGER = Logger.getLogger(RemoveUnusedComponents.class.getName());

    @Override
    public byte getOrder() {
        return 64;
    }

    @Override
    public OpenApi after(Context<? extends Trait> context, OpenApi openapi) {
        OpenApi current;
        if (context.getConfig().getKeepUnusedComponents()) {
            return openapi;
        }
        OpenApi result = openapi;
        while (!(result = this.removalRound(context, current = result)).equals(current)) {
        }
        result = this.removeUnusedSecuritySchemes(result);
        return result;
    }

    private OpenApi removalRound(Context<? extends Trait> context, OpenApi openapi) {
        String schemaPointerPrefix = context.getConfig().getDefinitionPointer() + "/";
        Set pointers = openapi.getComponents().getSchemas().keySet().stream().map(key -> schemaPointerPrefix + key).collect(Collectors.toSet());
        pointers.removeAll(this.findAllRefs(openapi.toNode().expectObjectNode()));
        if (pointers.isEmpty()) {
            return openapi;
        }
        LOGGER.info(() -> "Removing unused OpenAPI components: " + pointers);
        ComponentsObject.Builder componentsBuilder = openapi.getComponents().toBuilder();
        for (String pointer : pointers) {
            if (pointer.startsWith(schemaPointerPrefix)) {
                componentsBuilder.removeSchema(pointer.replace(schemaPointerPrefix, ""));
                continue;
            }
            throw new UnsupportedOperationException("Unreachable statement for not yet implemented removal");
        }
        return openapi.toBuilder().components(componentsBuilder.build()).build();
    }

    private Set<String> findAllRefs(ObjectNode node) {
        return (Set)node.accept((NodeVisitor)new NodeVisitor.Default<Set<String>>(){

            protected Set<String> getDefault(Node node) {
                return SetUtils.of();
            }

            public Set<String> arrayNode(ArrayNode node) {
                HashSet<String> result = new HashSet<String>();
                for (Node member : node.getElements()) {
                    result.addAll((Collection)member.accept((NodeVisitor)this));
                }
                return result;
            }

            public Set<String> objectNode(ObjectNode node) {
                HashSet<String> result = new HashSet<String>();
                if (node.getMember("$ref").isPresent()) {
                    node.getMember("$ref").flatMap(Node::asStringNode).map(StringNode::getValue).ifPresent(result::add);
                } else {
                    for (Node member : node.getMembers().values()) {
                        result.addAll((Collection)member.accept((NodeVisitor)this));
                    }
                }
                return result;
            }
        });
    }

    private OpenApi removeUnusedSecuritySchemes(OpenApi openapi) {
        Set used = openapi.getSecurity().stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toSet());
        for (PathItem path : openapi.getPaths().values()) {
            for (OperationObject operation : path.getOperations().values()) {
                for (Map entry : operation.getSecurity().orElse(Collections.emptyList())) {
                    used.addAll(entry.keySet());
                }
            }
        }
        TreeSet<String> unused = new TreeSet<String>(openapi.getComponents().getSecuritySchemes().keySet());
        unused.removeAll(used);
        if (unused.isEmpty()) {
            return openapi;
        }
        LOGGER.info("Removing unused OpenAPI security scheme definitions: " + unused);
        ComponentsObject.Builder componentsBuilder = openapi.getComponents().toBuilder();
        for (String unusedScheme : unused) {
            componentsBuilder.removeSecurityScheme(unusedScheme);
        }
        return openapi.toBuilder().components(componentsBuilder.build()).build();
    }
}

