/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.LinkObject;
import software.amazon.smithy.openapi.model.MediaTypeObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.Ref;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ResponseObject
extends Component
implements ToSmithyBuilder<ResponseObject> {
    private final String description;
    private final Map<String, Ref<ParameterObject>> headers;
    private final Map<String, MediaTypeObject> content;
    private final Map<String, Ref<LinkObject>> links;

    private ResponseObject(Builder builder) {
        super(builder);
        this.description = (String)SmithyBuilder.requiredState((String)"description", (Object)builder.description);
        this.headers = Collections.unmodifiableMap(new TreeMap(builder.headers));
        this.content = Collections.unmodifiableMap(new TreeMap(builder.content));
        this.links = Collections.unmodifiableMap(new TreeMap(builder.links));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<Ref<ParameterObject>> getHeader(String header) {
        for (Map.Entry<String, Ref<ParameterObject>> entry : this.headers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(header)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Map<String, Ref<ParameterObject>> getHeaders() {
        return this.headers;
    }

    public Map<String, MediaTypeObject> getContent() {
        return this.content;
    }

    public Map<String, Ref<LinkObject>> getLinks() {
        return this.links;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember("description", this.description);
        if (!this.headers.isEmpty()) {
            builder.withMember("headers", (ToNode)((ObjectNode)this.headers.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.content.isEmpty()) {
            builder.withMember("content", (ToNode)((ObjectNode)this.content.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.links.isEmpty()) {
            builder.withMember("links", (ToNode)((ObjectNode)this.links.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        return builder;
    }

    public Builder toBuilder() {
        return ((Builder)ResponseObject.builder().extensions(this.getExtensions())).description(this.description).headers(this.headers).content(this.content).links(this.links);
    }

    public static final class Builder
    extends Component.Builder<Builder, ResponseObject> {
        private String description;
        private final Map<String, Ref<ParameterObject>> headers = new TreeMap<String, Ref<ParameterObject>>();
        private final Map<String, MediaTypeObject> content = new TreeMap<String, MediaTypeObject>();
        private final Map<String, Ref<LinkObject>> links = new TreeMap<String, Ref<LinkObject>>();

        private Builder() {
        }

        public ResponseObject build() {
            return new ResponseObject(this);
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder putHeader(String name, Ref<ParameterObject> header) {
            this.headers.put(name, header);
            return this;
        }

        public Builder headers(Map<String, Ref<ParameterObject>> headers) {
            this.headers.clear();
            this.headers.putAll(headers);
            return this;
        }

        public Builder putContent(String name, MediaTypeObject mediaTypeObject) {
            this.content.put(name, mediaTypeObject);
            return this;
        }

        public Builder content(Map<String, MediaTypeObject> content) {
            this.content.clear();
            this.content.putAll(content);
            return this;
        }

        public Builder putLink(String name, Ref<LinkObject> link) {
            this.links.put(name, link);
            return this;
        }

        public Builder putLink(String name, LinkObject link) {
            return this.putLink(name, Ref.local(link));
        }

        public Builder links(Map<String, Ref<LinkObject>> links) {
            this.links.clear();
            this.links.putAll(links);
            return this;
        }
    }
}

