/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ExampleObject
extends Component
implements ToSmithyBuilder<ExampleObject> {
    private final String summary;
    private final String description;
    private final Node value;
    private final String externalValue;

    private ExampleObject(Builder builder) {
        super(builder);
        this.summary = builder.summary;
        this.description = builder.description;
        this.value = builder.value;
        this.externalValue = builder.externalValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getSummary() {
        return Optional.ofNullable(this.summary);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<Node> getValue() {
        return Optional.ofNullable(this.value);
    }

    public Optional<String> getExternalValue() {
        return Optional.ofNullable(this.externalValue);
    }

    public Builder toBuilder() {
        return ((Builder)ExampleObject.builder().extensions(this.getExtensions())).summary(this.summary).description(this.description).value(this.value).externalValue(this.externalValue);
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        return Node.objectNodeBuilder().withOptionalMember("summary", this.getSummary().map(Node::from)).withOptionalMember("description", this.getDescription().map(Node::from)).withOptionalMember("value", this.getValue().map(Node::from)).withOptionalMember("externalValue", this.getExternalValue().map(Node::from));
    }

    public static ExampleObject fromNode(Node exampleObject) {
        if (exampleObject == null) {
            return null;
        }
        NodeMapper mapper = new NodeMapper();
        mapper.setWhenMissingSetter(NodeMapper.WhenMissing.INGORE);
        ObjectNode node = exampleObject.expectObjectNode();
        Builder result = new Builder();
        mapper.deserializeInto((Node)node, (Object)result);
        return result.build();
    }

    public static final class Builder
    extends Component.Builder<Builder, ExampleObject> {
        private String summary;
        private String description;
        private Node value;
        private String externalValue;

        private Builder() {
        }

        public ExampleObject build() {
            return new ExampleObject(this);
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder value(Node value) {
            this.value = value;
            return this;
        }

        public Builder externalValue(String externalValue) {
            this.externalValue = externalValue;
            return this;
        }
    }
}

