/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.fromsmithy.OpenApiConverter;

public final class Smithy2OpenApi
implements SmithyBuildPlugin {
    public String getName() {
        return "openapi";
    }

    public void execute(PluginContext context) {
        OpenApiConverter converter = OpenApiConverter.create();
        context.getPluginClassLoader().ifPresent(converter::classLoader);
        OpenApiConfig config = OpenApiConfig.fromNode((Node)context.getSettings());
        ShapeId shapeId = config.getService();
        converter.config(config);
        ObjectNode openApiNode = converter.convertToNode(context.getModel());
        context.getFileManifest().writeJson(shapeId.getName() + ".openapi.json", (Node)openApiNode);
    }
}

