/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.protocols;

import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.protocols.ModelUtils;

final class HeaderSchemaVisitor<T extends Trait>
extends ShapeVisitor.Default<Schema> {
    private final Context<T> context;
    private final Schema schema;
    private final MemberShape member;

    HeaderSchemaVisitor(Context<T> context, Schema schema, MemberShape member) {
        this.context = context;
        this.schema = schema;
        this.member = member;
    }

    protected Schema getDefault(Shape shape) {
        return this.schema;
    }

    public Schema listShape(ListShape shape) {
        return this.collection((CollectionShape)shape);
    }

    public Schema setShape(SetShape shape) {
        return this.collection((CollectionShape)shape);
    }

    private Schema collection(CollectionShape collection) {
        MemberShape collectionMember = collection.getMember();
        Shape collectionTarget = this.context.getModel().expectShape(collectionMember.getTarget());
        Schema refSchema = this.context.inlineOrReferenceSchema(collectionMember);
        Schema itemsSchema = (Schema)collectionTarget.accept(new HeaderSchemaVisitor<T>(this.context, refSchema, collectionMember));
        return this.schema.toBuilder().ref(null).type("array").items(itemsSchema).build();
    }

    public Schema timestampShape(TimestampShape shape) {
        if (this.member.hasTrait(TimestampFormatTrait.class)) {
            return this.schema;
        }
        Schema original = this.context.getJsonSchemaConverter().convertShape((Shape)this.member).getRootSchema();
        Schema.Builder copiedBuilder = ModelUtils.convertSchemaToStringBuilder(original);
        return copiedBuilder.format(null).build();
    }

    public Schema stringShape(StringShape shape) {
        return shape.hasTrait(MediaTypeTrait.class) ? this.schema.toBuilder().ref(null).type("string").format("byte").build() : this.schema;
    }
}

