/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.openapi.fromsmithy.OpenApiConverter;

public final class Smithy2OpenApi
implements SmithyBuildPlugin {
    public String getName() {
        return "openapi";
    }

    public void execute(PluginContext context) {
        OpenApiConverter converter = OpenApiConverter.create();
        context.getSettings().getStringMap().forEach(converter::putSetting);
        context.getPluginClassLoader().ifPresent(converter::classLoader);
        ShapeId shapeId = ShapeId.from((String)context.getSettings().expectMember("service", this.getName() + " required a `service` shape ID is provided in the settings.").expectStringNode("`service` must be a string value").getValue());
        ObjectNode openApiNode = converter.convertToNode(context.getModel(), shapeId);
        context.getFileManifest().writeJson(shapeId.getName() + ".openapi.json", (Node)openApiNode);
    }
}

