/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.protocols;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiProtocol;
import software.amazon.smithy.openapi.fromsmithy.protocols.ModelUtils;
import software.amazon.smithy.openapi.model.MediaTypeObject;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.Ref;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

abstract class AbstractRestProtocol
implements OpenApiProtocol {
    AbstractRestProtocol() {
    }

    abstract String getDocumentMediaType(Context var1, Shape var2, MessageType var3);

    abstract Schema createDocumentSchema(Context var1, Shape var2, List<HttpBinding> var3, MessageType var4);

    @Override
    public Optional<OpenApiProtocol.Operation> createOperation(Context context, OperationShape operation) {
        return operation.getTrait(HttpTrait.class).map(httpTrait -> {
            String method = context.getOpenApiProtocol().getOperationMethod(context, operation);
            String uri = context.getOpenApiProtocol().getOperationUri(context, operation);
            OperationObject.Builder builder = OperationObject.builder().operationId(operation.getId().getName());
            HttpBindingIndex bindingIndex = (HttpBindingIndex)context.getModel().getKnowledge(HttpBindingIndex.class);
            this.createPathParameters(context, operation).forEach(builder::addParameter);
            this.createQueryParameters(context, operation).forEach(builder::addParameter);
            this.createRequestHeaderParameters(context, operation).forEach(builder::addParameter);
            this.createRequestBody(context, bindingIndex, operation).ifPresent(builder::requestBody);
            this.createResponses(context, bindingIndex, operation).forEach(builder::putResponse);
            return OpenApiProtocol.Operation.create(method, uri, builder);
        });
    }

    private List<ParameterObject> createPathParameters(Context context, OperationShape operation) {
        return ((HttpBindingIndex)context.getModel().getKnowledge(HttpBindingIndex.class)).getRequestBindings((ToShapeId)operation, HttpBinding.Location.LABEL).stream().map(binding -> {
            boolean needsInlineSchema;
            MemberShape member = binding.getMember();
            Schema schema = context.createRef((ToShapeId)binding.getMember());
            ParameterObject.Builder paramBuilder = ModelUtils.createParameterMember(context, member).in("path");
            boolean bl = needsInlineSchema = context.getModel().getShapeIndex().getShape(member.getTarget()).filter(Shape::isTimestampShape).isPresent() && !ModelUtils.getMemberTrait(context, (Shape)member, TimestampFormatTrait.class).isPresent();
            if (needsInlineSchema) {
                Schema.Builder copiedBuilder = ModelUtils.convertSchemaToStringBuilder(context.getSchema(context.getPointer((ToShapeId)member)));
                schema = copiedBuilder.format("date-time").build();
            }
            return paramBuilder.schema(schema).build();
        }).collect(Collectors.toList());
    }

    private List<ParameterObject> createQueryParameters(Context context, OperationShape operation) {
        return ((HttpBindingIndex)context.getModel().getKnowledge(HttpBindingIndex.class)).getRequestBindings((ToShapeId)operation, HttpBinding.Location.QUERY).stream().map(binding -> {
            ParameterObject.Builder param = ModelUtils.createParameterMember(context, binding.getMember()).in("query").name(binding.getLocationName());
            Shape target = (Shape)context.getModel().getShapeIndex().getShape(binding.getMember().getTarget()).get();
            if (target instanceof CollectionShape) {
                param.style("form").explode(true);
            }
            Schema refSchema = context.createRef((ToShapeId)binding.getMember());
            param.schema((Schema)target.accept((ShapeVisitor)new QuerySchemaVisitor(context, refSchema, binding.getMember())));
            return param.build();
        }).collect(Collectors.toList());
    }

    private Collection<ParameterObject> createRequestHeaderParameters(Context context, OperationShape operation) {
        List bindings = ((HttpBindingIndex)context.getModel().getKnowledge(HttpBindingIndex.class)).getRequestBindings((ToShapeId)operation, HttpBinding.Location.HEADER);
        return this.createHeaderParameters(context, bindings, MessageType.REQUEST).values();
    }

    private Map<String, ParameterObject> createHeaderParameters(Context context, List<HttpBinding> bindings, MessageType messageType) {
        return bindings.stream().map(binding -> {
            ParameterObject.Builder param = ModelUtils.createParameterMember(context, binding.getMember());
            if (messageType == MessageType.REQUEST) {
                param.in("header").name(binding.getLocationName());
            } else {
                param.in(null).name(null);
            }
            Shape target = (Shape)context.getModel().getShapeIndex().getShape(binding.getMember().getTarget()).get();
            Schema refSchema = context.createRef((ToShapeId)binding.getMember());
            param.schema((Schema)target.accept((ShapeVisitor)new HeaderSchemaVisitor(context, refSchema, binding.getMember())));
            return Pair.of((Object)binding.getLocationName(), (Object)param.build());
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private Optional<RequestBodyObject> createRequestBody(Context context, HttpBindingIndex bindingIndex, OperationShape operation) {
        List payloadBindings = bindingIndex.getRequestBindings((ToShapeId)operation, HttpBinding.Location.PAYLOAD);
        return payloadBindings.isEmpty() ? this.createRequestDocument(context, bindingIndex, operation) : this.createRequestPayload(context, (HttpBinding)payloadBindings.get(0));
    }

    private Optional<RequestBodyObject> createRequestPayload(Context context, HttpBinding binding) {
        MediaTypeObject mediaTypeObject = MediaTypeObject.builder().schema(context.createRef((ToShapeId)binding.getMember())).build();
        String mediaTypeRange = ModelUtils.getMediaType(context, binding.getMember());
        RequestBodyObject requestBodyObject = RequestBodyObject.builder().putContent(mediaTypeRange, mediaTypeObject).build();
        return Optional.of(requestBodyObject);
    }

    private Optional<RequestBodyObject> createRequestDocument(Context context, HttpBindingIndex bindingIndex, OperationShape operation) {
        List bindings = bindingIndex.getRequestBindings((ToShapeId)operation, HttpBinding.Location.DOCUMENT);
        if (bindings.isEmpty()) {
            return Optional.empty();
        }
        Schema schema = this.createDocumentSchema(context, (Shape)operation, bindings, MessageType.REQUEST);
        String mediaType = this.getDocumentMediaType(context, (Shape)operation, MessageType.REQUEST);
        return Optional.of(RequestBodyObject.builder().putContent(mediaType, MediaTypeObject.builder().schema(schema).build()).build());
    }

    private Map<String, ResponseObject> createResponses(Context context, HttpBindingIndex bindingIndex, OperationShape operation) {
        OperationIndex operationIndex = (OperationIndex)context.getModel().getKnowledge(OperationIndex.class);
        return Stream.concat(OptionalUtils.stream((Optional)operationIndex.getOutput((ToShapeId)operation)), operationIndex.getErrors((ToShapeId)operation).stream()).map(shape -> {
            StructureShape operationOrError = shape.hasTrait(ErrorTrait.class) ? shape : operation;
            String statusCode = context.getOpenApiProtocol().getOperationResponseStatusCode(context, (ToShapeId)operationOrError);
            ResponseObject response = this.createResponse(context, bindingIndex, statusCode, operation, (Shape)operationOrError);
            return Pair.of((Object)statusCode, (Object)response);
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (a, b) -> b, LinkedHashMap::new));
    }

    private ResponseObject createResponse(Context context, HttpBindingIndex bindingIndex, String statusCode, OperationShape operationShape, Shape operationOrError) {
        ResponseObject.Builder responseBuilder = ResponseObject.builder();
        responseBuilder.description(String.format("%s %s response", operationOrError.getId().getName(), statusCode));
        this.createResponseHeaderParameters(context, operationShape).forEach((k, v) -> responseBuilder.putHeader((String)k, Ref.local(v)));
        this.addResponseContent(context, bindingIndex, responseBuilder, operationOrError);
        return responseBuilder.build();
    }

    private Map<String, ParameterObject> createResponseHeaderParameters(Context context, OperationShape operation) {
        List bindings = ((HttpBindingIndex)context.getModel().getKnowledge(HttpBindingIndex.class)).getResponseBindings((ToShapeId)operation, HttpBinding.Location.HEADER);
        return this.createHeaderParameters(context, bindings, MessageType.RESPONSE);
    }

    private void addResponseContent(Context context, HttpBindingIndex bindingIndex, ResponseObject.Builder responseBuilder, Shape operationOrError) {
        List payloadBindings = bindingIndex.getResponseBindings((ToShapeId)operationOrError, HttpBinding.Location.PAYLOAD);
        if (!payloadBindings.isEmpty()) {
            this.createResponsePayload(context, (HttpBinding)payloadBindings.get(0), responseBuilder);
        } else {
            this.createResponseDocument(context, bindingIndex, responseBuilder, operationOrError);
        }
    }

    private void createResponsePayload(Context context, HttpBinding binding, ResponseObject.Builder responseBuilder) {
        String mediaType = ModelUtils.getMediaType(context, binding.getMember());
        responseBuilder.putContent(mediaType, MediaTypeObject.builder().schema(context.createRef((ToShapeId)binding.getMember())).build());
    }

    private void createResponseDocument(Context context, HttpBindingIndex bindingIndex, ResponseObject.Builder responseBuilder, Shape operationOrError) {
        List bindings = bindingIndex.getResponseBindings((ToShapeId)operationOrError, HttpBinding.Location.DOCUMENT);
        if (!bindings.isEmpty()) {
            MessageType messageType = operationOrError instanceof OperationShape ? MessageType.RESPONSE : MessageType.ERROR;
            Schema schema = this.createDocumentSchema(context, operationOrError, bindings, messageType);
            String mediaType = this.getDocumentMediaType(context, operationOrError, messageType);
            responseBuilder.putContent(mediaType, MediaTypeObject.builder().schema(schema).build());
        }
    }

    private static final class HeaderSchemaVisitor
    extends ShapeVisitor.Default<Schema> {
        private Context context;
        private Schema schema;
        private MemberShape member;

        private HeaderSchemaVisitor(Context context, Schema schema, MemberShape member) {
            this.context = context;
            this.schema = schema;
            this.member = member;
        }

        protected Schema getDefault(Shape shape) {
            return this.schema;
        }

        public Schema listShape(ListShape shape) {
            return this.collection((CollectionShape)shape);
        }

        public Schema setShape(SetShape shape) {
            return this.collection((CollectionShape)shape);
        }

        private Schema collection(CollectionShape collection) {
            Shape memberTarget = (Shape)this.context.getModel().getShapeIndex().getShape(collection.getMember().getTarget()).get();
            String memberPointer = this.context.getPointer((ToShapeId)collection.getMember());
            Schema currentMemberSchema = this.context.getSchema(memberPointer);
            Schema newMemberSchema = (Schema)memberTarget.accept((ShapeVisitor)new HeaderSchemaVisitor(this.context, currentMemberSchema, collection.getMember()));
            return this.schema.toBuilder().ref(null).type("array").items(newMemberSchema).build();
        }

        public Schema timestampShape(TimestampShape shape) {
            if (this.member.hasTrait(TimestampFormatTrait.class)) {
                return this.schema;
            }
            Schema.Builder copiedBuilder = ModelUtils.convertSchemaToStringBuilder(this.context.getSchema(this.context.getPointer((ToShapeId)this.member)));
            return copiedBuilder.format(null).build();
        }

        public Schema stringShape(StringShape shape) {
            return shape.hasTrait(MediaTypeTrait.class) ? this.schema.toBuilder().ref(null).type("string").format("byte").build() : this.schema;
        }
    }

    private static final class QuerySchemaVisitor
    extends ShapeVisitor.Default<Schema> {
        private Context context;
        private Schema schema;
        private MemberShape member;

        private QuerySchemaVisitor(Context context, Schema schema, MemberShape member) {
            this.context = context;
            this.schema = schema;
            this.member = member;
        }

        protected Schema getDefault(Shape shape) {
            return this.schema;
        }

        public Schema listShape(ListShape shape) {
            return this.collection((CollectionShape)shape);
        }

        public Schema setShape(SetShape shape) {
            return this.collection((CollectionShape)shape);
        }

        private Schema collection(CollectionShape collection) {
            Shape memberTarget = (Shape)this.context.getModel().getShapeIndex().getShape(collection.getMember().getTarget()).get();
            String memberPointer = this.context.getPointer((ToShapeId)collection.getMember());
            Schema currentMemberSchema = this.context.getSchema(memberPointer);
            Schema newMemberSchema = (Schema)memberTarget.accept((ShapeVisitor)new QuerySchemaVisitor(this.context, currentMemberSchema, collection.getMember()));
            return this.schema.toBuilder().ref(null).type("array").items(newMemberSchema).build();
        }

        public Schema timestampShape(TimestampShape shape) {
            if (this.member.hasTrait(TimestampFormatTrait.class)) {
                return this.schema;
            }
            Schema.Builder copiedBuilder = ModelUtils.convertSchemaToStringBuilder(this.context.getSchema(this.context.getPointer((ToShapeId)this.member)));
            return copiedBuilder.format("date-time").build();
        }

        public Schema blobShape(BlobShape shape) {
            return this.schema.toBuilder().ref(null).type("string").format("byte").build();
        }
    }

    static enum MessageType {
        REQUEST,
        RESPONSE,
        ERROR;

    }
}

